/********************************************************************\
 * File.c -- simple file utilities                                  *
 * Copyright (C) 1997 Robin D. Clark                                *
 * Copyright (C) 1998 Linas Vepstas                                 *
 * Copyright (C) 1998 Rob Browning                                  *
 * Copyright (C) 1999-2000 Linas Vepstas                            *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *                                                                  *
 *   Author: Rob Clark                                              *
 * Internet: rclark@cs.hmc.edu                                      *
 *  Address: 609 8th Street                                         *
 *           Huntington Beach, CA 92648-4632                        *
\********************************************************************/

#include <fcntl.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include <guile/gh.h>

#include "config.h"
#include "File.h"
#include "messages.h"
#include "util.h"

/********************************************************************\
\********************************************************************/

char *
gncFindFile (const char * filename) 
{
  char *full_filename = NULL;
  /* This should be gh_lookup, but that appears to be broken */
  SCM find_doc_file = gh_eval_str("gnc:find-doc-file");
  SCM scm_filename = gh_str02scm ((char *) filename);
  SCM scm_result;

  scm_result = gh_call1(find_doc_file, scm_filename);

  if (scm_result != SCM_BOOL_F)
    full_filename = gh_scm2newstr(scm_result, NULL);

  return full_filename;
}

/********************************************************************\
 * htmlRead                                                         * 
 *                                                                  * 
 * Args:   file - the name of the html file to read                 * 
 * Return: none                                                     * 
 * Global: helpPath - the path to the help files                    * 
\********************************************************************/
char *
gncReadFile (const char * file )
{
  char *buf=NULL;
  char  *filename;
  int   size=0;
  int   fd;

  /* construct absolute path -- twiddle the relative path we recieved */
  if (!file) return NULL;
  filename = gncFindFile (file);
  if (!filename) return NULL;

  /* Open file: */
  fd = open( filename, O_RDONLY );

  free(filename); filename = NULL;

  if( fd == -1 )
  {
    ERROR();
    fprintf (stderr, "file was %s \n", file);
    return NULL;
  }
  
  /* Find size: */
  size = lseek( fd, 0, SEEK_END );
  lseek( fd, 0, SEEK_SET );

  /* Allocate memory... don't use _malloc(), `cause it is
   * freed elsewhere */
  buf = (char *)malloc((size+1)*sizeof(char));

  /* read in file */
  if( read(fd,buf,size) == -1 )
  {
    free(buf);
    buf=NULL;
  }
  buf[size] = 0x0;
  
  close(fd);
  return buf;
}

/* ----------------------- END OF FILE ---------------------  */
