/********************************************************************\
 * enriched-messages.h -- simple text formatting                    *
 * Copyright (C) 1999 Laurent Plecq                                *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
\********************************************************************/

#ifndef _XACC_ENRICHED_MESSAGES_H_
#define _XACC_ENRICHED_MESSAGES_H_

#include "messages.h"

/* with colons at end */
enum with_colons_index_t
{
  ACC_CODE_C_IDX,
  ACC_NAME_C_IDX,
  AMOUNT_C_IDX,
  ASSETS_C_IDX,
  BALN_C_IDX,
  CLEARED_C_IDX,
  CREDITS_C_IDX,
  CURRENCY_C_IDX,
  DATE_C_IDX,
  DEBITS_C_IDX,
  DESC_C_IDX,
  DIFF_C_IDX,
  END_BALN_C_IDX,
  END_DATE_C_IDX,
  FROM_C_IDX,
  MEMO_C_IDX,
  PARENT_ACC_C_IDX,
  PREV_BALN_C_IDX,
  PROFITS_C_IDX,
  QUOTE_SRC_C_IDX,
  SECURITY_C_IDX,
  START_DATE_C_IDX,
  TO_C_IDX,
  TOTAL_C_IDX,
  NUMBER_OF_STRINGS_WITH_COLONS
};

/* with elipses at end (for menu items) */
enum with_elipses_index_t
{
  ABOUT_E_IDX=NUMBER_OF_STRINGS_WITH_COLONS,
  ACCOUNTS_E_IDX,
  ADJ_BALN_E_IDX,
  ADJ_BALN_MENU_E_IDX,
  DATE_RANGE_E_IDX,
  DEL_ACC_E_IDX,
  EDIT_ACCT_E_IDX,
  END_BALN_MENU_E_IDX,
  HELP_E_IDX,
  HIDE_INC_EXP_E_IDX,
  IMPORT_QIF_E_IDX,
  LICENSE_E_IDX,
  NEW_ACC_E_IDX,
  NEW_ACC_MENU_E_IDX,
  NEW_FILE_E_IDX,
  OPEN_ACC_E_IDX,
  OPEN_FILE_E_IDX,
  OPEN_SUB_E_IDX,
  PREFERENCES_MENU_E_IDX,
  PRINT_E_IDX,
  RECONCILE_E_IDX,
  RECONCILE_MENU_E_IDX,
  REPORT_E_IDX,
  SAVE_E_IDX,
  SAVE_AS_E_IDX,
  SET_RANGE_MENU_E_IDX,
  SHOW_INC_EXP_E_IDX,
  SIMPLE_E_IDX,
  TRANSFER_E_IDX,
  TRANSFER_MENU_E_IDX,
  NUMBER_OF_STRINGS_WITH_COLONS_OR_ELIPSES
};

extern char *enriched_message[NUMBER_OF_STRINGS_WITH_COLONS_OR_ELIPSES];

/* with colons at end */
#define ACC_CODE_C_STR		(enriched_message[ACC_CODE_C_IDX])
#define ACC_NAME_C_STR		(enriched_message[ACC_NAME_C_IDX])
#define AMOUNT_C_STR            (enriched_message[AMOUNT_C_IDX])
#define ASSETS_C_STR		(enriched_message[ASSETS_C_IDX])
#define BALN_C_STR		(enriched_message[BALN_C_IDX])
#define CLEARED_C_STR		(enriched_message[CLEARED_C_IDX])
#define CREDITS_C_STR		(enriched_message[CREDITS_C_IDX])
#define CURRENCY_C_STR		(enriched_message[CURRENCY_C_IDX])
#define DATE_C_STR              (enriched_message[DATE_C_IDX])
#define DEBITS_C_STR		(enriched_message[DEBITS_C_IDX])
#define DESC_C_STR		(enriched_message[DESC_C_IDX])
#define DIFF_C_STR		(enriched_message[DIFF_C_IDX])
#define END_BALN_C_STR		(enriched_message[END_BALN_C_IDX])
#define END_DATE_C_STR          (enriched_message[END_DATE_C_IDX])
#define FROM_C_STR		(enriched_message[FROM_C_IDX])
#define MEMO_C_STR              (enriched_message[MEMO_C_IDX])
#define PARENT_ACC_C_STR	(enriched_message[PARENT_ACC_C_IDX])
#define PREV_BALN_C_STR		(enriched_message[PREV_BALN_C_IDX])
#define PROFITS_C_STR		(enriched_message[PROFITS_C_IDX])
#define QUOTE_SRC_C_STR		(enriched_message[QUOTE_SRC_C_IDX])
#define SECURITY_C_STR		(enriched_message[SECURITY_C_IDX])
#define START_DATE_C_STR        (enriched_message[START_DATE_C_IDX])
#define TO_C_STR		(enriched_message[TO_C_IDX])
#define TOTAL_C_STR		(enriched_message[TOTAL_C_IDX])

/* with elipses at end (for menu items) */
#define ABOUT_E_STR		(enriched_message[ABOUT_E_IDX])
#define ACCOUNTS_E_STR		(enriched_message[ACCOUNTS_E_IDX])
#define ADJ_BALN_E_STR		(enriched_message[ADJ_BALN_E_IDX])
#define ADJ_BALN_MENU_E_STR	(enriched_message[ADJ_BALN_MENU_E_IDX])
#define DATE_RANGE_E_STR        (enriched_message[DATE_RANGE_E_IDX])
#define DEL_ACC_E_STR		(enriched_message[DEL_ACC_E_IDX])
#define EDIT_ACCT_E_STR		(enriched_message[EDIT_ACCT_E_IDX])
#define END_BALN_MENU_E_STR     (enriched_message[END_BALN_MENU_E_IDX])
#define HELP_E_STR		(enriched_message[HELP_E_IDX])
#define HIDE_INC_EXP_E_STR	(enriched_message[HIDE_INC_EXP_E_IDX])
#define IMPORT_QIF_E_STR	(enriched_message[IMPORT_QIF_E_IDX])
#define LICENSE_E_STR		(enriched_message[LICENSE_E_IDX])
#define NEW_ACC_E_STR		(enriched_message[NEW_ACC_E_IDX])
#define NEW_ACC_MENU_E_STR	(enriched_message[NEW_ACC_MENU_E_IDX])
#define NEW_FILE_E_STR		(enriched_message[NEW_FILE_E_IDX])
#define OPEN_ACC_E_STR		(enriched_message[OPEN_ACC_E_IDX])
#define OPEN_FILE_E_STR		(enriched_message[OPEN_FILE_E_IDX])
#define OPEN_SUB_E_STR		(enriched_message[OPEN_SUB_E_IDX])
#define PREFERENCES_MENU_E_STR  (enriched_message[PREFERENCES_MENU_E_IDX])
#define PRINT_E_STR		(enriched_message[PRINT_E_IDX])
#define RECONCILE_E_STR		(enriched_message[RECONCILE_E_IDX])
#define RECONCILE_MENU_E_STR	(enriched_message[RECONCILE_MENU_E_IDX])
#define REPORT_E_STR		(enriched_message[REPORT_E_IDX])
#define SAVE_E_STR		(enriched_message[SAVE_E_IDX])
#define SAVE_AS_E_STR		(enriched_message[SAVE_AS_E_IDX])
#define SET_RANGE_MENU_E_STR    (enriched_message[SET_RANGE_MENU_E_IDX])
#define SHOW_INC_EXP_E_STR	(enriched_message[SHOW_INC_EXP_E_IDX])
#define SIMPLE_E_STR		(enriched_message[SIMPLE_E_IDX])
#define TRANSFER_E_STR		(enriched_message[TRANSFER_E_IDX])
#define TRANSFER_MENU_E_STR	(enriched_message[TRANSFER_MENU_E_IDX])

void buildEnrichedMessages ();

#endif /* _XACC_ENRICHED_MESSAGES_H_ */
