/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#include <sys/types.h>
#endif
#ifdef AIX
#include <sys/select.h>
#include <values.h>
#endif
#include <dirent.h>
#if defined Linux || defined NEXTSTEP
#include <sys/dir.h>
#endif
#if defined unicos || defined SunOS
#include <fcntl.h>
#endif
#include <sys/time.h>
#include "main.h"

extern void send_oob_error(int, char *);
extern char *time_string(void);

short mycmp(char *s1, char *s2)
{
   for (; *s1 == *s2 && *s1 && *s2; s1++, s2++);
   if (!*s1 && !*s2) return 0;
   return 1;
}


void free_vec(char **vec)
{
   if (vec && *vec) {
      char **tmp=vec;
      for (; *tmp; tmp++);
      for (tmp--; tmp != vec; tmp--) {
         free(*tmp);
         *tmp = NULL;
      }
      free(*tmp);
      *tmp = NULL;
   }
}


void free_memory(void)
{
   if ((*statstr)->SENDMAKELINKS) {
      unlink((*statstr)->SENDMAKELINKS);
      free((*statstr)->SENDMAKELINKS);
      (*statstr)->SENDMAKELINKS=NULL; 
   }
#ifdef HAVE_INET6
   if ((*statstr)->adin) freeaddrinfo((*statstr)->adin);
#endif
   free_vec(_CLIENTHOSTNAME_);
}


long dir_size(char **name)
{
   char *sargv[PFTP_MAX_PFM_ENTRY];
   DIR *ff;
   long size=0, c=0;
   struct stat buf;
#if defined Linux || defined NEXSTEP
   struct direct *dir;
#else
   struct dirent *dir;
#endif

   for (; *name && !stat(*name, &buf); name++) {
      if ((buf.st_mode & S_IFREG)) {
         size += buf.st_size;
      }
      else if ((buf.st_mode & S_IFDIR)) {
         if ((ff = opendir(*name))) {
            size += buf.st_size;
            while ((dir = readdir(ff))) {
               if (dir->d_ino && strcmp(".", dir->d_name) && strcmp("..", dir->d_name)) {
                  MEM_CHECK((*(sargv+c) = (char *)calloc(LONAME, sizeof(char))));
                  sprintf(*(sargv+c), "%s/%s", *name, dir->d_name);
                  c++;
               }
            }
            closedir(ff);
         }
         *(sargv+c) = NULL;
         size += dir_size(sargv);
         while (c) {
            c--;
            if (sargv[c]) free(sargv[c]);
         }
      }
   }
   return size;
}


int check_dir_size(int strnum, double *filesize)
{
   char *sargv[PFTP_MAX_PFM_ENTRY];
   struct stat buf;

   /*
    * Check if there is another client sending data.
    */
   if (stat((*(statstr+strnum))->uploaddir_lock, &buf)) return 0;
   if (buf.st_nlink != 2) (*(statstr+strnum))->calc_dir = BIT_ONE;
   if ((*(statstr+strnum))->calc_dir) {
      if (buf.st_nlink == 2) (*(statstr+strnum))->calc_dir = 0;
      *sargv = (*(statstr+strnum))->uploaddir;
      *(sargv+1) = NULL;
      (*(statstr+strnum))->last_dir_size = (double)dir_size(sargv) + *filesize;
   }
   else (*(statstr+strnum))->last_dir_size += *filesize;

   if ((*(statstr+strnum))->mul <= (*(statstr+strnum))->last_dir_size) {
      send((*(statstr+strnum))->ws, PFTP_NOSPACELEFT, PFTP_NOSPACELEFT_LEN, MSG_OOB);
      if (slfp) {
         fprintf(slfp, "%s %s No space left\n", \
         time_string(), (*(statstr+strnum))->pw_name);
      }
      return 0;
   }
   return 1;
}


short netip_check(char *hostip, char *netip)
{
   int j=0, hn=1, i=0;
   unsigned char *htmp=NULL, *ntmp=NULL, h, n;
#ifdef HAVE_INET6
   const int max=IPv6_BIN_ADDR_LENGTH;
   char hostbin[IPv6_BIN_ADDR_LENGTH];
   char netbin[IPv6_BIN_ADDR_LENGTH];

   if (inet_pton(AF_INET6, hostip, hostbin) <= 0) return 0;
   if (inet_pton(AF_INET6, netip, netbin) <= 0) return 0;
   htmp = hostbin + max - 1;
   ntmp = netbin + max - 1;
#else
   const int max=IPv4_BIN_ADDR_LENGTH;
   union {
      unsigned char ch[IPv4_BIN_ADDR_LENGTH];
      unsigned long num;
   } hunip, nunip;
   hunip.num = inet_addr(hostip);
   nunip.num = inet_addr(netip);
   htmp = hunip.ch + max - 1;
   ntmp = nunip.ch + max - 1;
#endif

   for (i=max; i; i--, htmp--, ntmp--) {
      h = *htmp;
      n = *ntmp;
      for (j=0; hn && j < 8; j++, h >>= 1, n >>= 1) {
         if ((n & 01)) hn = 0;
      }
      if (!hn && h != n) return 0;
   }
   return 1;
}


int substitute_string(char *str, int begin)
{
   FILE *fp=NULL;
   char name[SONAME];
   char *tmpstr=NULL, *tmpn=NULL;
   char type = *(str+begin+1);

   *name = '\0';
   if (!type || *(str+begin+2) != '<') {
      *str = PFTP_SPECIAL_SIGN;
      *(str+1) = '\0';
      return 0;
   }
   for (tmpstr=str+begin+3, tmpn=name; \
       *tmpstr && *tmpstr != '>'; tmpstr++, tmpn++) {
      *tmpn = *tmpstr;
   }
   if (*tmpstr != '>') type = 0;
   *tmpn = '\0';

   if (*name) {
      if (type == 'V') {
         /*
          * Substitute the string with the variable.
          */
         if ((tmpstr = getenv(name))) {
            if (strlen(tmpstr) + begin < SONAME) {
               strcpy(str+begin, tmpstr);
               return 1;
            }
         }
      }
      else if (type == 'F') {
         /*
          * Substitute string with the first
          * line of the file.
          */
         if ((fp = fopen(name, "r"))) {
            if (fgets(str+begin, SONAME-begin, fp)) {
               fclose(fp);
               for (tmpstr=str+begin; *tmpstr && *tmpstr != '\n'; tmpstr++);
               *tmpstr = '\0';
               return 1;
            }
            fclose(fp);
         }
      }
   }
   *str = PFTP_SPECIAL_SIGN;
   *(str+1) = '\0';
   return 0;
}


void find_free_name(char *name, char *str)
{
   unsigned long number=0; /* This should be enough ;^) */

   do { 
      number++;
      sprintf(str, "%s.%lu", name, number);
   } while (!access(str, F_OK));
}


int skip_upper_dirs(int strnum, int dont_write, int smode)
{
   int cc, ccc, pp;
   char *fname = (*(statstr+strnum))->cwd_last_ch;
   char *name = fname;

   if ((*(statstr+strnum))->_RECURS_) {
      for (ccc=cc=pp=0; cc < LONAME && *(fname+cc); cc++) {
         /*
          * Avoiding trojan horses.
          */
         *(name+ccc) = *(fname+cc);
         if (*(name+ccc) == '.') pp++;
         else if (*(name+ccc) != '/') pp = 0;

         ccc++;
         if (*(fname+cc) == '/') {
            if (pp == 1) {
               ccc -= 2;
            }
            else if (pp == 2) {
               ccc -= 3;
            }
            else if (ccc == 1) {
               ccc = 0;
            }
            else if (!dont_write) {
               *(name+ccc-1) = '\0';
               if (access((*(statstr+strnum))->cwd, F_OK)) {
                  if (mkdir((*(statstr+strnum))->cwd, smode)) {
                     send_oob_error(strnum, (*(statstr+strnum))->cwd);
                     return 0;
                  }
                  *(name+ccc-1) = '/';
               }
               else *(name+ccc-1) = '/';
            }
            pp = 0;
         }
      }
      if (ccc) *(name+ccc) = '\0';
   }
   else {
      char *d=NULL;
      /*
       * Strip directory path.
       */
      for (name=fname; *name; name++);
      for (; name != fname && *name != '/'; name--);
      if (*name == '/') name++;
      for (d=fname; (*d = *name); d++, name++);
   }
   if (!*fname) return 0;

   return 1;
}


int get_file_status(int strnum, pftp_file_status *pfs)
{
   char *ptr=pfs->end;
   char *str=pfs->input;
   char set_file_info=0, set_dir_info=0;
   char special_info_set=0, fifo_info_set=0;
   int ret = 2;

   pfs->info = 0;
   pfs->size = 0;
   pfs->mode = 0;
   for (; *ptr != ' ' && ptr != str; ptr--);
   if (str == ptr) return 0;
   *ptr = '\0';
   if (!mycmp(ptr+1, "f1")) set_file_info = 1; /* set information for normal file */
   else if (!mycmp(ptr+1, "d1")) set_dir_info = 1; /* create empty directory */
   else if (!mycmp(ptr+1, "g1")) special_info_set = 1; /* create special file */
   else if (!mycmp(ptr+1, "p1")) {
      special_info_set = 1; /* create special file */
      fifo_info_set = 1;
   }
   else {
      pfs->size = atof(ptr+1);
      for (; *ptr != ' ' && ptr != str; ptr--);
      if (str == ptr) return 0;
      *ptr = '\0';
      pfs->mode = atoi(ptr+1);
      strcpy(pfs->name, str);
      return 1;
   }

   /*
    * Reading some file/directory information.
    */
   for (; *ptr != ' ' && ptr != str; ptr--);
   if (str == ptr) return 0;
   *ptr = '\0';
   pfs->time[1].tv_sec = (double)atol(ptr+1);
   pfs->time[0].tv_sec = pfs->time[1].tv_sec;
   pfs->time[0].tv_usec = pfs->time[1].tv_usec = 0;
   for (; *ptr != ' ' && ptr != str; ptr--);
   if (str == ptr) return 0;
   *ptr = '\0';
   if (set_file_info || special_info_set) {
      pfs->size = (double)atol(ptr+1);
      for (; *ptr != ' ' && ptr != str; ptr--);
      if (str == ptr || (!(pfs->size) && !special_info_set)) return 0;
      *ptr = '\0';
   }
   pfs->gid = (double)atoi(ptr+1);
   for (; *ptr != ' ' && ptr != str; ptr--);
   if (str == ptr) return 0;
   *ptr = '\0';
   pfs->uid = (double)atoi(ptr+1);
   for (; *ptr != ' ' && ptr != str; ptr--);
   if (str == ptr) return 0;
   *ptr = '\0';
   pfs->mode = (double)atoi(ptr+1);
   if (!*str) return 0;
   strcpy(pfs->name, str);
   if ((*(statstr+strnum))->accept_file_info) pfs->info = 1;
   (*(statstr+strnum))->fad_info++; /* number of received file and directory information */
   if (set_file_info) return 1;

   /*
    * Create directory according to the
    * directory information.
    */
   if ((((*(statstr+strnum))->_RECURS_ && set_dir_info) \
         || special_info_set) && pfs->info) {
      int smode = 0755;
      umask(~smode);
      if (skip_upper_dirs(strnum, 0, smode)) {
         if (slfp && (!((*statstr)->_PFTP_DAEMON_) || (*statstr)->lognames)) {
            fprintf(slfp, "+ Received information about %s from %s.\n", \
                   pfs->name, (*(statstr+strnum))->REMOTEHOSTNAME);
         }
         if (access((*(statstr+strnum))->cwd, F_OK)) {
            if (special_info_set) {
               if (!getuid()) {
                  if (mknod((*(statstr+strnum))->cwd, pfs->mode, pfs->size) < 0) {
                     send_oob_error(strnum, pfs->name);
                     ret = 3;
                  }
               }
               else {
                  if (fifo_info_set) {
                     if (mkfifo((*(statstr+strnum))->cwd, pfs->mode) < 0) {
                        send_oob_error(strnum, pfs->name);
                        ret = 3;
                     }
                  }
                  else {
                     int fd=0;
                     if ((fd = open((*(statstr+strnum))->cwd, O_CREAT|O_WRONLY|O_TRUNC, pfs->mode)) < 0) {
                        send_oob_error(strnum, pfs->name);
                        ret = 3;
                     }
                     close(fd);
                  }
               }
            }
            else {
               if (mkdir((*(statstr+strnum))->cwd, pfs->mode)) {
                  send_oob_error(strnum, pfs->name);
                  ret = 3;
               }
            }
         }
         if (ret == 2) {
            if (chmod((*(statstr+strnum))->cwd, pfs->mode) < 0) {
               send_oob_error(strnum, pfs->name);
               ret = 3;
            }
            if (!getuid() && chown((*(statstr+strnum))->cwd, pfs->uid, pfs->gid)) {
               send_oob_error(strnum, pfs->name);
               ret = 3;
            }
            else if (utimes((*(statstr+strnum))->cwd, (struct timeval *)pfs->time)) {
               send_oob_error(strnum, pfs->name);
               ret = 3;
            }
         }
      }
   }
   return ret;
}


int check_version(char *remote_version, char *needed_version)
{
   int rnumt, rnums, rnump;
   int nnumt, nnums, nnump;

   sscanf(remote_version, "%d.%d.%d", &rnumt, &rnums, &rnump);
   sscanf(needed_version, "%d.%d.%d", &nnumt, &nnums, &nnump);

   if (rnumt > nnumt) return 1;
   if (rnumt == nnumt) {
      if (rnums > nnums) return 1;
      if (rnums == nnums) {
         if (rnump >= nnump) return 1;
      }
   }
   return 0;
}
