(* Network address handling module.

This file is part of Liece.                                          

Author: Daiki Ueno <daiki@kake.info.waseda.ac.jp>                    
Created: 1998-09-28                                               
Revised: 1999-01-28                                               
Keywords: IRC, liece, DCC                                        

This program is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2, or (at your option)  
any later version.                                                   
                                                                      
This program is distributed in the hope that it will be useful,      
but WITHOUT ANY WARRANTY; without even the implied warranty of       
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the      
GNU General Public License for more details.                         
                                                                      
You should have received a copy of the GNU General Public License    
along with GNU Emacs; see the file COPYING.  If not, write to the    
Free Software Foundation, Inc., 59 Temple Place - Suite 330,         
Boston, MA 02111-1307, USA.  *)

open Num
open Big_int
open Str

let encode str =
  let _ = string_match 
      (regexp "\([0-9]+\)\.\([0-9]+\)\.\([0-9]+\)\.\([0-9]+\)") str 0 in
  let (a1, a2, a3, a4) = 
    try 
      int_of_string (matched_group 1 str), 
      int_of_string (matched_group 2 str), 
      int_of_string (matched_group 3 str), 
      int_of_string (matched_group 4 str)
    with
      _ -> 
	Printf.eprintf "Invalid address\n"; flush Pervasives.stdout; exit 1;
  in
  let (s1, s2, s3, s4) =
    Int (1 lsl 24), 
    Int (1 lsl 16), 
    Int (1 lsl 8), 
    Int 1
  in
  let ul =
    ((Int a1) */ s1) +/ ((Int a2) */ s2) +/ ((Int a3) */ s3) +/ (Int a4)
  in
  string_of_num ul

let decode str =
  let ul = 
    try
      num_of_string str 
    with
      _ ->
	Printf.eprintf "Invalid address\n"; flush Pervasives.stdout; exit 1;
  in
  let (s1, s2, s3, s4) =
    Int (1 lsl 24), 
    Int (1 lsl 16), 
    Int (1 lsl 8), 
    Int 1
  in
  let (a1, a2, a3, a4) = 
    floor_num (ul // s1), 
    floor_num ((mod_num ul s1) // s2), 
    floor_num ((mod_num (mod_num ul s1) s2) // s3), 
    (mod_num (mod_num (mod_num ul s1) s2) s3)
  in
  Printf.sprintf "%s.%s.%s.%s" 
    (string_of_num a1) 
    (string_of_num a2) 
    (string_of_num a3) 
    (string_of_num a4)
