/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "geomclass.h"

Geom *
GeomDice( Geom *g, int nu, int nv )
{
    if( g && g->ap && g->ap->valid & APF_DICE) {
	nu = g->ap->dice[0];	/* Propagate "dice" appearance values */
	nv = g->ap->dice[1];	/* Note we ignore overrides, so this may not be
				 * correct in some cases.
				 */
    }
    if( g && g->Class->dice )
	(*g->Class->dice)(g, nu, nv);
    return g;
}
