/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips, Celeste Fowler */

#ifndef POINT3DEFS
#define POINT3DEFS
/*
** Definitions for 3D float points:
*/

typedef float Pt3Coord;
typedef struct { Pt3Coord x, y, z; } Point3;

void Pt3Print(const Point3 *p);
void Pt3From(Point3 *p, double x, double y, double z);
void Pt3Copy(const Point3 *a, Point3 *b);

void Pt3Add(const Point3 *a, const Point3 *b, Point3 *c);
void Pt3Sub(const Point3 *a, const Point3 *b, Point3 *c);
void Pt3Neg(const Point3 *a, Point3 *b);
void Pt3Mul(double s, const Point3 *a, Point3 *b);
void Pt3Comb(double sa, const Point3 *a, 
	     double sb, const Point3 *b, Point3 *c);
void Pt3Lerp(double t, const Point3 *a, const Point3 *b, Point3 *c);

Pt3Coord Pt3Dot(const Point3 *a, const Point3 *b);
void Pt3Cross(const Point3 *a, const Point3 *b, Point3 *c);
Pt3Coord Pt3TripleDot(const Point3 *a, const Point3 *b, const Point3 *c);
void Pt3TripleCross(const Point3 *a, const Point3 *b, const Point3 *c, 
		    Point3 *d);

Pt3Coord Pt3Distance(const Point3 *a, const Point3 *b);
Pt3Coord Pt3Length(const Point3 *p);
Pt3Coord Pt3Angle(const Point3 *a, const Point3 *b);

int Pt3Equal(const Point3 *a, const Point3 *b);
int Pt3Parallel(const Point3 *a, const Point3 *b);
int Pt3Perpendicular(const Point3 *a, const Point3 *b);

/* Note -- this was incorrect -- there is only one arg
   Tamara Munzner 7/17/90 */
void Pt3Unit(Point3 *a);

/* these should be in transform3.h, not here --- Oliver 11/20/92 */

void Pt3Transform(/* Transform3 T, const Point3 *a, Point3 *b */);
void Pt3TransformN(/* Transform3 T, const Point3 *a, Point3 *b, int n */);

void NormalTransform(/* Transform3 T, const Point3 *a, Point3 *b */);
void NormalTransformN(/* Transform3 T, const Point3 *a, Point3 *b, int n */);

extern Point3 Pt3Origin;

#define Pt3X(pt) (pt)->x
#define Pt3Y(pt) (pt)->y
#define Pt3Z(pt) (pt)->z

float SgSgDistance(Point3 *a1, Point3 *a2,
		   Point3 *b1, Point3 *b2);


#endif
