#include "geom.h"
#include "bbox.h"
#include <string.h>

main(int argc, char *argv[]) {
	Geom *g = NULL;
	BBox *b = NULL, *bb = NULL;
	HPoint3 min, max;
	int i;
	char *p, objname[512];
	int asmodule = (argc <= 1);

	if(asmodule) {
	    printf("(echo (real-id target) '\\n')\n");
	    printf("(write geometry - target world)\n");
	    fflush(stdout);

	    fgets(objname+4, sizeof(objname)-4, stdin);	/* Expect "name"\n */
	    memcpy(objname, "bbox-", 5);			/* => bbox-name"\n */
	    if((p = strchr(objname, '"'))) *p = '\0';	/* Toss quote */
	    if((p = strchr(objname, '\n'))) *p = '\0';	/* Toss any newline */
	    g = GeomFLoad(stdin, NULL);			/* Now expect geometry */
	    if(g == NULL) {
		fprintf(stderr, "addbbox: Couldn't read target's geometry\n");
		exit(1);
	    }
	    b = (BBox *)GeomBound(g, TM_IDENTITY);
	} else {
	    while(argc > 1) {
		g = (strcmp(argv[--argc], "-")) ?
			GeomLoad(argv[argc]) : GeomFLoad(stdin, "stdin");
		if(g) {
			bb = (BBox *)GeomBound(g, TM_IDENTITY);
			GeomDelete(g);
			b = BBoxUnion3(bb, b, b);
		} else {
			fprintf(stderr,
				"addbbox: Couldn't read geometry from %s: %s\n",
				argv[argc], sperror());
			exit(1);
		}
	    }
	}

	BBoxMinMax(b, &min, &max);

	if(asmodule) {
	    printf("(progn\n");
	    printf("(geometry \"%s\" { appearance {*-normal *-face *+edge}\n",
		    objname);
	}
	printf("# BBox %g %g  %g %g  %g %g\n",
		min.x,max.x, min.y,max.y, min.z,max.z);
	printf("OFF\n  8 12 0\n\n");
	for(i=0; i<8; i++)
	    printf("%g %g %g\n", i&1?min.x:max.x, i&2?min.y:max.y,
				 i&4?min.z:max.z);
	printf("\n");
	for(i = 0; i < 8; i++) {
	    if(!(i&1)) printf("2\t%d %d\n", i, i+1);
	    if(!(i&2)) printf("2\t%d %d\n", i, i+2);
	    if(!(i&4)) printf("2\t%d %d\n", i, i+4);
	}
	if(asmodule) {
	    printf("})\n");
	    printf("(normalization \"%s\" none)\n", objname);
	    printf(")\n");
	}
	exit(0);
}
