/* 
file: textwindow.cc
*/
#include "textwindow.h"

///////////////////////////////////////////////////////
extern char *courier12; 
extern char *fixed12;
extern char *timesbold12;

char* line1 = "This example shows ";
char* line2 ="different colours ";
char* line3 = "and different fonts\n";
char* line4 = "in a single text widget\n";
char* line5 = "that's all folk !";

DEFINE_SIGNAL_MAP(TextWindow,VDKForm)
  ON_SIGNAL(wordwrap,clicked_signal,ToggleWordWrap),
  ON_SIGNAL(text,realize_signal,OnRealizeText) 
END_SIGNAL_MAP

void
TextWindow::Setup() 
{
VDKBox *box = new VDKBox(this);
Add(box);
navy  = new VDKColor(this,0,0,130); // navy blue
red = new VDKColor(this,255,0,0); // red
green = new VDKColor(this,0,255,0); // green
blue = new VDKColor(this,0,0,255); // blue
box->Add(text = new VDKText(this,true));
box->Add(wordwrap = new VDKLabelButton(this,"Toggle word wrap"));
}
/*
 */
bool
TextWindow::OnRealizeText(VDKObject*)
{
// use default
text->TextInsert(line1);
// chage font and colors
text->TextFont.foreground = *navy;
text->TextFont.font = new VDKFont(this,courier12);
text->TextInsert(line2);

text->TextFont.foreground = *red;
text->TextFont.font = new VDKFont(this,fixed12);
text->TextInsert(line3);

text->TextFont.foreground = *green;
text->TextFont.font = new VDKFont(this,timesbold12);
text->TextInsert(line4);
// reset to default
text->TextFont.foreground = NULL;
text->TextFont.font = NULL;
text->TextInsert(line5);
text->Changed = false;
return true;
}
/* 
 */ 
bool
TextWindow::ToggleWordWrap(VDKObject*)
{
  text->WordWrap = text->WordWrap ? false : true;
  return true;
}
/*
 */
bool TextWindow::CanClose()
{
if(text->Changed)
  Application()->MessageBox("VDK", "Text was changed",
			  MB_ICONINFORMATION|MB_OK);
return true; 
}


 
