/*   
=====================  
File: testvdk.cc
VDK 0.5.0 test program    
=====================
*/                     
#include "testvdk.h" 
#include "scrollwin.h"    
#include "textwin.h"         
#include "textwindow.h"     
#include "sortlistwin.h"         
#include "ctreewin.h"         
#include "entrieswin.h"        
#include "progresswin.h"        
#include "canvaswin.h"     
#include "panedwin.h"     
#include "nbookwin.h"       
#include "signalwin.h" 
#include "rbuttonwin.h"  
#include <vdk/FileDialog.h>
#include "tbarwin.h"
#include "rcwin.h"
#include "rangewin.h"
#include "benchwin.h"
#include "combowin.h"
#include "tchart.h"
#include "vdkgridwin.h"
#include "packerwin.h"
#include "databoxwin.h"
#include "dnd.h"
#include <gdk/gdkkeysyms.h>
#include <vdk/vdkcolorbrowser.h>

#define TIMER   10000 
#define BROWSER 5000 
/*
   pixmaps (in pixmaps.cc)   
*/      
extern char *mini_ofolder_xpm[];    
extern char * book_xpm[]; 
extern char * mini_bball_xpm[]; 
          
/* 
=================================================
ALL TESTS HERE 
=================================================
*/  
#define LISTCOL 3 
TestApp* TheApplication;
static char buff[256];
static char vdk_version[64];
static char* titles[LISTCOL] = { "Test it", "View source code","Avail"};
void MakeScrolledWindow(int ndx);
void MakeMessageBox(int);
void MakeTextWin(int ndx);
void MakeSortedListWin(int ndx);
void MakeTreeWin(int ndx);
void MakeEntriesWin(int ndx); 
void MakeProgressWin(int ndx);
void MakeCanvasWin(int ndx); 
void MakePanedWin(int ndx);
void MakeNotebookWin(int ndx); 
void MakeFileBrowser(int ndx);
void MakeFileSel(int ndx);
void MakeSignalsWin(int ndx);
void MakeRadioButtonWin(int ndx);
void MakeToolBarWin(int ndx);
void MakeRangeWin(int ndx);
void MakeBenchWin(int ndx);
void MakeComboWin(int ndx);
void MakeChartWin(int ndx);
void MakeColorBrowWin(int ndx);
void MakeGridWin(int ndx);
void MakePackerWin(int ndx);
void MakeDataBoxWin(int ndx);
void MakeDnDWin(int ndx);
struct
{ 
  char *items[LISTCOL]; 
  void (*foo)(int);  
  char* source; 
  VDKForm* form,*sourceform;   
} test[MAXTEST] =  
{    

  /* test                 source   avail    function           source         form  source form*/
  {{"About sigs & evs" ,  "yes",   "yes" }, MakeSignalsWin     ,"signalwin"  ,NULL, NULL},
  {{"Canvas",             "yes",   "yes" }, MakeCanvasWin      ,"canvaswin"  ,NULL, NULL},
  {{"Combo box",          "yes",   "yes" }, MakeComboWin       ,"combowin"   ,NULL, NULL},
  {{"Custom tree",        "yes",   "yes" }, MakeTreeWin        ,"ctreewin"   ,NULL, NULL},
  {{"Databox",            "yes",   "yes" }, MakeDataBoxWin     ,"databoxwin" ,NULL, NULL},
  {{"Drag & drop",        "yes",   "yes" }, MakeDnDWin         ,"dnd" ,NULL, NULL},
  {{"Entries",            "yes",   "yes" }, MakeEntriesWin     ,"entrieswin" ,NULL, NULL},
  {{"File dialog",        "no" ,   "yes" }, MakeFileBrowser    , NULL        ,NULL, NULL},
  {{"File sel (ala gtk+)","no" ,   "yes" }, MakeFileSel        , NULL        ,NULL, NULL},
  {{"Grid",               "yes",   "yes" }, MakeGridWin        ,"vdkgridwin" ,NULL, NULL},
  {{"MessageBox",         "no" ,   "yes" }, MakeMessageBox     , NULL        ,NULL, NULL},
  {{"Note book",          "yes",   "yes" }, MakeNotebookWin    ,"nbookwin"   ,NULL, NULL},
  {{"Packer",             "yes",   "yes" }, MakePackerWin      ,"packerwin"  ,NULL, NULL},
  {{"Paned widget",       "yes",   "yes" }, MakePanedWin       ,"panedwin"   ,NULL, NULL},
  {{"Progress bar",       "yes",   "yes" }, MakeProgressWin    ,"progresswin",NULL, NULL},
  {{"Radio buttons   " ,  "yes",   "yes" }, MakeRadioButtonWin ,"rbuttonwin" ,NULL, NULL},
  {{"Range and spins",    "yes",   "yes" }, MakeRangeWin       ,"rangewin"   ,NULL, NULL},
  {{"Scrolled ",          "yes",   "yes" }, MakeScrolledWindow ,"scrollwin"  ,NULL, NULL}, 
  {{"Signal benchmark" ,  "yes",   "yes" }, MakeBenchWin       ,"benchwin"   ,NULL, NULL},
  {{"Sorted list",        "yes",   "yes" }, MakeSortedListWin  ,"sortlistwin",NULL, NULL},
  {{"Text",               "yes",   "yes" }, MakeTextWin        ,"textwindow" ,NULL, NULL},
  {{"Toolbar",            "yes",   "yes" }, MakeToolBarWin     ,"tbarwin"    ,NULL, NULL},
  {{"VDK chart",          "yes",   "yes" }, MakeChartWin       ,"tchart"     ,NULL, NULL},
  {{"VDK color browser",  "no",    "yes" }, MakeColorBrowWin   , NULL        ,NULL, NULL}
};

 
void MakeScrolledWindow(int ndx)  
{ 
WaitCursor c(TheApplication->MainForm);
ScrollWin* child = new ScrollWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
}

void MakeMessageBox(int )
{
TheApplication->
  MessageBox("VDK MessageBox",
	     "Do you like it ?\nThis is a modal message box\n\
(should be more aesthetic)",
	     MB_ICONINFORMATION|MB_OK);
}


void MakeTextWin(int ndx)
{
  TextWindow* child = new TextWindow(TheApplication->MainForm);
  test[ndx].form = child; 
  child->Setup();
  child->Show();
}

void MakeSortedListWin(int ndx)
{
  SortedListWindow* child = new SortedListWindow(TheApplication->MainForm);
  test[ndx].form = child; 
  child->Setup(); 
  child->Show();
}

void MakeTreeWin(int ndx)
{
  TreeWindow* child = new TreeWindow(TheApplication->MainForm);
  test[ndx].form = child; 
  child->Setup(); 
  child->Show();
}

void 
MakeEntriesWin(int ndx)
{
EntriesWin* child = new EntriesWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
}

void 
MakeProgressWin(int ndx)
{
ProgressWin* child = new ProgressWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
} 

void 
MakeCanvasWin(int ndx)
{
CanvasWin* child = new CanvasWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
}

void 
MakePanedWin(int ndx)
{
WaitCursor c(TheApplication->MainForm);
PanedWin* child = new PanedWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
} 

void 
MakeNotebookWin(int ndx)
{
WaitCursor c(TheApplication->MainForm);
NoteBookWin* child = new NoteBookWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
} 

void MakeFileBrowser(int ndx)
{
FileStringArray selections;
VDKFileDialog  *child = new VDKFileDialog(
					  TheApplication->MainForm,
					  &selections,
					  "File Open dialog");
test[ndx].form = child;   
child->ShowModal();
for( int t = 0; t < selections.size(); t++)
  {
  printf("\nselection:%s",(char*) selections[t]);
  fflush(stdout);
  } 
}   

void MakeColorBrowWin(int ndx)
{
VDKColorBrowserParms parms;
VDKColorBrowser* child = new VDKColorBrowser(TheApplication->MainForm,
					     &parms);
test[ndx].form = child; 
child->Setup();
child->ShowModal();
if(parms.rgb.red >= 0)
  {
    printf("\nselected color: VDKRgb(%d,%d,%d), name:%s",
	   parms.rgb.red,parms.rgb.green,parms.rgb.blue,parms.colorname);
    fflush(stdout);
  }
}


void MakeFileSel(int ndx)
{
char selection[512];
strcpy(selection,"*.h");
VDKFileSel* child = new VDKFileSel(TheApplication->MainForm,
				   selection,
				   "File selection (ala Gtk+)");
test[ndx].form = child; 
child->Setup();
child->Show(); 
if(*selection)
  {
    printf("\nselection:%s",selection);
    fflush(stdout);
  }
}

void  
MakeSignalsWin(int ndx)
{
SignalWin* child = new SignalWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
}

void
MakeRadioButtonWin(int ndx)
{
RadioButtonWin* child = new RadioButtonWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
}

void
MakeToolBarWin(int ndx)
{
ToolBarWin* child = new ToolBarWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
} 

void
MakeRangeWin(int ndx)
{
RangeWin* child = new RangeWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
}  

void
MakeBenchWin(int ndx)
{
BenchWin* child = new BenchWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
}

void
MakeComboWin(int ndx)
{
ComboWin* child = new ComboWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
}

void
MakeChartWin(int ndx)
{
ChartForm* child = new ChartForm(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
}

void MakeGridWin(int ndx)
{
  VDKGridWindow* child = new VDKGridWindow(TheApplication->MainForm);
  test[ndx].form = child; 
  child->Setup();
  child->Show();
}
void 
MakePackerWin(int ndx)
{
VDKPackerWindow* child = new VDKPackerWindow(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
} 
void 
MakeDataBoxWin(int ndx)
{
DataBoxWin* child = new DataBoxWin(TheApplication->MainForm);
test[ndx].form = child; 
child->Setup();
child->Show();
} 
void 
MakeDnDWin(int ndx)
{
DndForm* child = new DndForm(TheApplication->MainForm,NULL);
test[ndx].form = child; 
child->Setup();
child->Show();
} 
/*
=================================     
MAIN FORM  
=================================
*/
/*   
signals map   
*/ 
DEFINE_SIGNAL_MAP(TestForm,VDKForm)
  //  ON_SIGNAL(mainmenu,activate_signal,PopMainMenu), 
  ON_SIGNAL(quit_menu,activate_signal,Quit), 
  ON_SIGNAL(testcode_menu,activate_signal,TestCode), 
  ON_SIGNAL(rc_menu,activate_signal,RcCode), 
  ON_SIGNAL(help_menu,activate_signal,OnHelp), 
  ON_SIGNAL(list,select_row_signal,HandleListSelection),
  ON_SIGNAL(list,unselect_row_signal,HandleListUnselection), 
  ON_SIGNAL(list,click_column_signal,HandleColumnClick),
  ON_SIGNAL(browser,event_browser_signal,OnBrowser),
  ON_SIGNAL(timer,timer_tick_signal,TimerTick),
  ON_SIGNAL(combobutton,clicked_signal,OnClickedComboButton)
END_SIGNAL_MAP 
/*  
event map  
*/
DEFINE_EVENT_MAP(TestForm,VDKForm)
  ON_EVENT(pixmap,double_click_event,OnClickLogo) 
END_EVENT_MAP          
/*
dyna signal map
 */
DEFINE_SIGNAL_LIST(TestForm,VDKForm);

/* 
constructor  
 */
TestForm::TestForm(VDKApplication* app, gchar* title,int mode):
    VDKForm(app,title,v_box,(GtkWindowType) mode) { }
/*
destructor
 */
TestForm::~TestForm() {}
/*
set up main form
 */
void TestForm::Setup() 
{ 
  // vdk version
  sprintf(vdk_version,"VDK %d.%d.%d",
	  VDK_VERSION_MAJOR,VDK_VERSION_MINOR,VDK_REVISION);
  //
  VDKRawPixmap* icon = new VDKRawPixmap(this,"./pixmap/cube.xpm");
  SetIcon(icon);
  SetIconName(vdk_version);
  browser = NULL;
  // makes bottom bar   
  bottombar = new VDKPanelbar(this,3);
  bottombar->Panels()[0]->Caption = vdk_version;
  calendardate today;
  bottombar->Panels()[1]->Caption = today.CalendarDate();
  bottombar->Panels()[2]->Caption = "Lazy day !";
  Add(bottombar,r_justify,FALSE,FALSE,0);
  // makes menu
  VDKMenubar* menubar = new VDKMenubar(this);
  mainmenu =  
    new VDKMenuItem(this,"none",mini_ofolder_xpm);
  mainmenu->Caption = "_Menu..";
  menubar->Add(mainmenu,l_justify,true,true,false);
  menu = new VDKMenu(this);
  testcode_menu =  
    new VDKMenuItem(menu,"_Shows test code");
  rc_menu =   
    new VDKMenuItem(menu,"Sho_ws rc file");
  menu->Separator(); 
  quit_menu = new VDKMenuItem(menu,"none"); 
  mainmenu->Add(menu);
  quit_menu->Caption = "_Quit";
  
  help_menu = new VDKMenuItem(menubar,"Help <Ctrl+h>",book_xpm,r_justify,
			      GDK_h,GDK_CONTROL_MASK);
  Add(menubar,l_justify,FALSE,FALSE,0); 
      
  // add a frame to form
  VDKBox *frame = new VDKBox(this,v_box);  
  Add(frame,l_justify,false,false); 
     // add a v_box to frame
     frame->Add(vbox = new VDKBox(this,v_box),l_justify,false,false);
     VDKBox *hc_box = new VDKBox(this,h_box);
     combobutton = new 
       VDKCustomButton(this,
		       mini_ofolder_xpm,
		       "Test list",
		       VDK_CBUTTON_UNTOGGLED | VDK_CBUTTON_COMBO); 
     // fills combo menu with items
     combomenu = new VDKMenu(this);
     for (int z = 0;  z < MAXTEST; z++)
       {
	 menuitems[z] = new VDKMenuItem(combomenu,test[z].items[0]);
	 SignalConnect(menuitems[z],"activate",&TestForm::OnActivateComboMenu);
       }
     combobutton->SetComboMenu(combomenu);
     combobutton->SetSize(-1,30);
     hc_box->Add(combobutton,l_justify,false,false,false);
     vbox->Add(hc_box,l_justify,false,false,2);
     // makes a list 
     list = new VDKCustomList(this,LISTCOL,titles);
     list->SetSize(-1/*350*/,list->RowHeight*10);
     // sets list colors 
     if(VDKRgb("cornsilk").IsValid())
	 list->NormalBackground = VDKRgb("cornsilk");
     if(VDKRgb("red3").IsValid())
       list->SelectedBackground = new VDKColor(this,VDKRgb("red3"));
     list->SelectedForeground = new VDKColor(this,clWhite);  
     // add list rows
     for (int i = 0; i < MAXTEST; i++) 
       list->AddRow(test[i].items, NULL,1);  
     // sets column titles properties
     list->ActiveTitle(2,false);  
     list->Titles[0]->Enabled = false; 
     list->Titles[1]->Enabled = false;
     list->Titles[0]->SetTip("Click to test");
     list->SelectRow(0,0);
     // add the list to vbox
     vbox->Add(list);
     vbox->Add(new VDKSeparator(this,h_separator),l_justify,
	       false,false);
     // add another v_box to frame 
     frame->Add(vbox1 = new VDKBox(this,v_box));
      // add a pixmap to v_box1
      // add labels too
      vbox1->Add(pixmap = new VDKPixmap(this,		
					"./pixmap/vdklogo.xpm"),
		 l_justify,false,false);
      VDKTooltip* tip = new VDKTooltip(this,pixmap,
		       "Double click here\rand change your life");
      vbox1->Add(new VDKSeparator(this,h_separator),l_justify,false,false);
      sprintf(buff,"%s\n%s\n%s",
	      "Mario Motta <mmotta@guest.net>",
	      "Ionut Borcoman <borco@borco-ei.eng.hokudai.ac.jp>",
	      "Tim Lorenz <Tim.Lorenz@stud.uni-hannover.de>");
      vbox1->Add(label = 
		 new VDKLabel(this,
			      buff,
			      GTK_JUSTIFY_CENTER),l_justify,false,false);
      label->Foreground = clSiena;
      /*
	connect realize/unrealize
      */
      SignalConnect("realize",&TestForm::OnRealize);
      SignalConnect("unrealize",&TestForm::OnUnrealize);
      /*
       */
      FocusWidget = list;
}  
/*
 */
bool 
TestForm::OnClickedComboButton(VDKObject*)
{
  char* p;
  int t,ndx = -1;
  VDKLabel* label = combobutton->Label;
  if(!label)
    return true;
  p = label->Caption;
  for(t=0; t < MAXTEST;t++)
    if(!strcmp(p,test[t].items[0]))
      {
       ndx = t;
       break;
      }
  if(ndx >= 0)
    {
      if(test[ndx].form)
	test[ndx].form->Raise();
      else
	test[ndx].foo(ndx);
    }
  return true;
}
/*
 */
bool 
TestForm::OnActivateComboMenu(VDKObject* item)
{
  // look up on menuitems array to match the right index
  int ndx = -1;
  for(int t = 0; t < MAXTEST; t++)
    if(menuitems[t] == item)
      {
       ndx = t;
       break;
      }
  // match found
  // set button label
  // raises or launch test window
  if(ndx >= 0)
    {
      VDKLabel* label = combobutton->Label;
      if(label)
	label->Caption = test[ndx].items[0];
      if(test[ndx].form)
	test[ndx].form->Raise();
      else
	test[ndx].foo(ndx);
    }
  return true;
}
/*
 */
bool TestForm::OnRealize(VDKObject*)
{
printf("\nRealize it");
fflush(stdout);
return true;
}
bool TestForm::OnUnrealize(VDKObject*)
{
printf("\nUnrealize it");
fflush(stdout);
return true;

}

/*
Timer Tick
 */
bool TestForm::TimerTick(VDKObject*)
{
static unsigned int secs = 0;
secs++;
sprintf(buff,"Lazy day -:) %02u:%02u",secs/60,secs%60);
bottombar->Panels()[2]->Caption = buff;
return true;
}            
/*  
can close query   
*/
bool TestForm::CanClose()
{
  if(Application()->MessageBox(vdk_version,
			       "Sure to quit ?",
			       MB_ICONQUESTION|MB_YESNO,
			       "_Leave test application",
			       "_Cancel") == IDYES)
    {
      if(browser) browser->Stop();
      return true;
    }  
  else   
    return false;  
}    
/*
Response functions
 */
bool TestForm::OnHelp(VDKObject*)
{
Application()->MessageBox(vdk_version,
			  "Sorry, not yet implemented",
			  MB_ICONINFORMATION|MB_OK);
return true;
}

bool TestForm::Quit(VDKObject*) 
{ 
Close(); 
return true;
}
/*
 */
bool 
TestForm::HandleListSelection(VDKObject*)
{
  int ndx = list->Selected.Row();
  if(ndx >= 0)
    {
      list->Titles[1]->Enabled = 
	(
	 (! strcmp((char*) list->Tuples[ndx][1],"yes") )&& 
	 (! strcmp((char*) list->Tuples[ndx][2],"yes"))
	 );
      list->Titles[0]->Enabled = ! strcmp((char*) list->Tuples[ndx][2],"yes");
    }
  return true;
}

/*
 */
bool 
TestForm::HandleColumnClick(VDKObject*)
{
int ndx = list->Selected.Row();
if(ndx < 0) 
  return true;
TextWin* child;
switch(list->ColumnClicked())
  {
  case 0:  
    // exec foo() or raises an already mapped child
	if(test[ndx].form)
	    test[ndx].form->Raise();
	else
	  {
	    list->UpdateCell(ndx,0,test[ndx].items[0],mini_bball_xpm);
	    test[ndx].foo(ndx);
	  }
    break;
  case 1: // source view column clicked
    if(!test[ndx].sourceform)
      {
	sprintf(buff,"%s source code: %s.h & %s.cc",
		test[ndx].items[0],
		test[ndx].source,
		test[ndx].source);
	child = new TextWin(this,buff,test[ndx].source); 
	child->Setup();
	child->Visible = true;
	test[ndx].sourceform = child;
	list->UpdateCell(ndx,1,test[ndx].items[1],book_xpm);
      }
    else
      {
      test[ndx].sourceform->Raise();
      }
    break;
  }
return true;
}

/*
 */
void
TestForm::OnChildClosing(VDKForm* child)
{
int t;
for(t=0; t < MAXTEST;t++)
    if(test[t].form == child)
      {
	test[t].form = NULL;
	list->UpdateCell(t,0,test[t].items[0]);
	return;
      }
for(t=0; t < MAXTEST;t++)
    if(test[t].sourceform == child)
      {
	test[t].sourceform = NULL;
	list->UpdateCell(t,1,test[t].items[1]);
	return;
      }
}
/*
 */
bool
TestForm::HandleListUnselection(VDKObject*)
{
  list->EnableTitles(false);
  return true;
}
 
/*
 */ 
bool TestForm::TestCode(VDKObject*) 
{
  sprintf(buff,"Test program source code: texvdk.cc");
  TextWin* child = new TextWin(this,buff,"testvdk"); 
  child->Setup();
  child->Usize = VDKPoint(600,400);
  child->Visible = true;
  return true;
}
/*
 */ 
bool TestForm::RcCode(VDKObject*) 
{
  sprintf(buff,"Test program resources file: rcfile");
  RcWin* child = new RcWin(this,buff,"rcfile"); 
  child->Setup();
  child->Usize = VDKPoint(400,400);
  child->Visible = true;
  return true;
}
/*
 */
bool TestForm::OnClickLogo(VDKObject*, GdkEvent*)
{
Application()->MessageBox(vdk_version,
			  "I WANT YOU !\nVDK needs supporters!",
			  MB_OK|MB_ICONSTOP);
return true;
}
/*
 */
bool TestForm::OnBrowser(VDKObject*)
{
if(browser->Event->key.keyval == GDK_Escape)
    Close();
return true;  
} 
/*
 */
void 
TestForm::OnResize(VDKForm* sender, VDKPoint& newsize)
{
printf("\nnew size p(%d,%d)",newsize.x,newsize.y);
fflush(stdout); 
}
/*
 */
void 
TestForm::OnMove(VDKForm* sender)
{
VDKPoint newpos = Position;
printf("\nnew position p(%d,%d)",
       newpos.x,newpos.y);
fflush(stdout); 
}
/* 
=================================================
TEST APPLICATION CLASS
=================================================
*/
/*
constructor  
*/
TestApp::TestApp(int* argc, char** argv): 
  VDKApplication(argc,argv) { }
/*
destructor
*/
TestApp::~TestApp() { }
/*
 */  
void TestApp::Setup() 
{
  // STUB
  SetGarbageCollection(2000);
  MainForm = new TestForm(this,"VDK Test program",v_box);
  MainForm->Setup();
  MainForm->Show();    
} 
//==============================
// main program
//============================== 
int main (int argc, char *argv[])      
{
  TheApplication = new TestApp(&argc, argv);
  TheApplication->SetResourceFile("rcfile");
  TheApplication->Run();
  delete TheApplication;
  return 0;  
}  
    


     

