/* 
file: packerwin.cc
*/
#include "packerwin.h"
#include <stdlib.h>
/////////////////////////////////////////
DEFINE_SIGNAL_MAP(VDKPackerWindow,VDKForm)
  ON_SIGNAL(reconfigure,clicked_signal,Reconfigure)
END_SIGNAL_MAP

DEFINE_SIGNAL_LIST(VDKPackerWindow,VDKForm);
static VDKCustomButton* selectedButton = NULL;

/*
 */
bool
VDKPackerWindow::OnSelectButton(VDKObject* obj)
{
  VDKCustomButton* btn = dynamic_cast<VDKCustomButton*>(obj);
  if(btn)
    selectedButton = btn;
  // modified for gcc 2.95 by Ionutz
  button1->Caption = (char *)((btn == button1) ? "selected" : "unselected");
  button2->Caption = (char *)((btn == button2) ? "selected" : "unselected");
 return true;
}
/*
 */
bool
VDKPackerWindow::Reconfigure(VDKObject*)
{
if(! selectedButton)
  return true;
int sidesel = side->Selected;
int anchorsel = anchor->Selected;
int fill_x = fillx->Checked ? int(GTK_FILL_X) : 0;
int fill_y = filly->Checked ? int(GTK_FILL_Y) : 0;
int expanded = expand->Checked ? int(GTK_PACK_EXPAND) : 0;

sidesel = sidesel < 0 ? int(GTK_SIDE_TOP) : sidesel;
anchorsel = anchorsel < 0 ? int(GTK_ANCHOR_CENTER): anchorsel;
packer->ReconfigureChild(selectedButton, 
		 sidesel,
		 anchorsel, 
		 int(fill_x | fill_y | expanded),
		 0);
return true;
}

static char* sides[] = 
{
"top","bottom","left","right",0
};
static char*anchors[] = 
{
"center","north","nort-west","north-east",
"south","south-west","south-east",
"west","east",0
};
/////////////////////////////////////////
/*
 */
void     
VDKPackerWindow::Setup() 
{
  int t;
  SetSize(300,200);
  Add(packer = new VDKPacker(this));
  button1 = new VDKCustomButton(this,"unselected");
  packer->Add(button1);
  SignalConnect(button1,"clicked",&VDKPackerWindow::OnSelectButton);
  button2 = new VDKCustomButton(this,"unselected");
  packer->Add(button2);
  SignalConnect(button2,"clicked",&VDKPackerWindow::OnSelectButton);

  VDKFrame *frame = new VDKFrame(this,"",v_box);

  VDKFrame *frame1 = new VDKFrame(this,"",h_box);
  frame1->Add(new VDKLabel(this," Side: "),l_justify,false,false,false);
  side = new VDKCombo(this,sides[0]);
  StringList sl;
  for(t=0;sides[t];t++)
    sl.add(VDKString(sides[t]));
  side->PopdownStrings = sl;
  frame1->Add(side);

  frame1->Add(new VDKLabel(this," Anchor: "),l_justify,false,false,false);
  anchor = new VDKCombo(this,anchors[0]);
  StringList sa;
  for(t=0;anchors[t];t++)
    sa.add(VDKString(anchors[t]));
  anchor->PopdownStrings = sa;
  frame1->Add(anchor);
  frame->Add(frame1, l_justify,false,false,false);

  VDKFrame *frame2 = new VDKFrame(this,"",h_box);
  frame2->Add(expand = new VDKCheckButton(this,"Expand"),
	     l_justify,false,false,false);
  frame2->Add(fillx = new VDKCheckButton(this,"Fill X"),
	     l_justify,false,false,false);
  frame2->Add(filly = new VDKCheckButton(this,"Fill Y"),
	     l_justify,false,false,false);
  frame2->Add(reconfigure = new VDKCustomButton(this,"Reconfigure child"),
	     l_justify,false,false,false);
  frame->Add(frame2, l_justify,false,false,false);


  Add(frame,l_justify,false,false,false);

}






