/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * Revision 0.4.1
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef WIDCONTAIN_H
#define WIDCONTAIN_H
#include <vdk/vdkobj.h>

class VDKObjectContainer: public VDKObject
{
public:
  VDKObjectContainer(VDKForm* owner);
  virtual ~VDKObjectContainer() {}

  int BorderWidth(int w = -1)
    {
      if(w>=0)
	gtk_container_set_border_width (GTK_CONTAINER (widget),w); 
      return GTK_CONTAINER (widget)->border_width;
    }

  virtual void Add(VDKObject* obj, int ,
		   int , int , int )
    { 
      items.add(obj);
       /* sets the default border width */
      //BorderWidth(3);
      gtk_widget_show(obj->Widget());
      obj->Parent(this);
      obj->Setup();
    }
  
  void RemoveObject(VDKObject* obj) { obj->Destroy(); }
  // called from VDKObject::Destroy()
  // overrided on some container sublass
  virtual void RemoveObjectFromContainer(VDKObject* obj);
  void RemoveObjects();
  //
  VDKObject* FindTag(int tag);
  void ForEachDo(void (*action)(VDKObject*));
  void Select(ItemList* list, bool (*condition)(VDKObject*));
  
};
#endif

