/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/resource.h>
#include <signal.h>
#include <gtk/gtk.h>
#include "gps.h"
#include "msgbox.h"
#include "renice.h"

extern gint pid_sel;

GtkWidget *nicedlg;

void renice_dialog(GtkWidget * widget, gpointer data) {
  GtkWidget *dlg;
  GtkWidget *v1,*h1,*ok,*can,*h2,*l1,*h3,*pp,*hs,*est;
  static GtkWidget *sb;
  GtkObject *ad;
  int n,u;

  n=get_nicety(pid_sel);
  if (n==-1) {
    refresh();
    return;
  }

  u=getuid();
  
  dlg=gtk_window_new(GTK_WINDOW_DIALOG);
  nicedlg=dlg;

  v1=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(dlg),v1);
  gtk_window_set_title(GTK_WINDOW(dlg),"Renice Process");
  gtk_container_set_border_width(GTK_CONTAINER(dlg),6);
  GTK_WINDOW(dlg)->position=GTK_WIN_POS_CENTER;
  gtk_widget_show(dlg);

  h1=gtk_hbox_new(FALSE,0);
  l1=gtk_label_new("New (absolute) nice value:");
  
  gtk_box_pack_start(GTK_BOX(v1),h1,FALSE,FALSE,2);
  gtk_box_pack_start(GTK_BOX(h1),l1,FALSE,FALSE,2);
  gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_LEFT);

  ad=gtk_adjustment_new((gfloat)n,(gfloat)((u==0)?-20:n),20.0,1.0,1.0,1.0);
  sb=gtk_spin_button_new(GTK_ADJUSTMENT(ad),0.1,0);
  gtk_entry_set_editable(GTK_ENTRY(sb),FALSE);

  h3=gtk_hbox_new(TRUE,0);
  pp=gtk_label_new(" ");
  gtk_box_pack_start(GTK_BOX(h3),pp,FALSE,TRUE,0);
  gtk_widget_show(pp);

  gtk_box_pack_start(GTK_BOX(v1),h3,FALSE,TRUE,4);
  gtk_box_pack_start(GTK_BOX(h3),sb,FALSE,TRUE,4);

  pp=gtk_label_new(" ");
  gtk_box_pack_start(GTK_BOX(h3),pp,FALSE,TRUE,0);
  gtk_widget_show(pp);
  
  hs=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v1),hs,FALSE,TRUE,4);

  h2=gtk_hbox_new(FALSE,4);
  ok=gtk_button_new_with_label(" Ok ");
  can=gtk_button_new_with_label(" Cancel ");

  est=gtk_label_new(" ");

  gtk_box_pack_start(GTK_BOX(v1),h2,FALSE,TRUE,2);
  gtk_box_pack_start(GTK_BOX(h2),est,TRUE,TRUE,2);
  gtk_box_pack_end(GTK_BOX(h2),can,FALSE,FALSE,4);
  gtk_box_pack_end(GTK_BOX(h2),ok,FALSE,FALSE,4);

  /*  GTK_WIDGET_SET_FLAGS(ok,GTK_CAN_DEFAULT);
      gtk_widget_grab_default(ok);*/

  //  gtk_container_set_border_width(GTK_CONTAINER(ok),1);

  gtk_widget_show(ok);
  gtk_widget_show(can);
  gtk_widget_show(est);
  gtk_widget_show(hs);
  gtk_widget_show(h2);
  gtk_widget_show(sb);
  gtk_widget_show(l1);
  gtk_widget_show(h1);
  gtk_widget_show(v1);
  gtk_widget_show(h3);

  gtk_signal_connect(GTK_OBJECT(ok),"clicked",
		     GTK_SIGNAL_FUNC(renice_set_ok),(gpointer)(sb));
  gtk_signal_connect(GTK_OBJECT(can),"clicked",
		     GTK_SIGNAL_FUNC(renice_set_cancel),NULL);
  gtk_grab_add(dlg);
}

void renice_set_cancel(GtkWidget *gw,gpointer data) {
  gtk_grab_remove(nicedlg);
  gtk_widget_destroy(nicedlg);
}

void renice_set_ok(GtkWidget *gw,gpointer data) {
  GtkWidget *s;
  int n,nnv,r,en;
  char *msg;

  s=(GtkWidget *)data;
  n=get_nicety(pid_sel);
  if (n!=-1) {
    nnv=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(s));
    r=setpriority(PRIO_PROCESS,pid_sel,nnv);
    en=errno;
    gtk_grab_remove(nicedlg);
    gtk_widget_destroy(nicedlg);
    refresh();
    if (r==-1) {
      switch(en) {
      case ESRCH:
	msg=ERR_NICE_NOTFOUND;
	break;
      case EINVAL:
	msg=ERR_NICE_WEIRD;
	break;
      case EACCES:
      case EPERM:
	msg=ERR_NICE_PERM;
	break;
      default:
	msg=ERR_NICE_WEIRD2;
      }
      message_box_ok(msg,"Unable to renice",MSGBOX_ICON_ERROR);
    }
  }
}

int get_nicety(int pid) {
  FILE *f;
  char buffer[1024];
  int i;
  sprintf(buffer,"/proc/%d/stat",pid);
  f=fopen(buffer,"r");
  if (f==NULL)
    return -1;
  fgets(buffer,1024,f);
  fclose(f);
  strtok(buffer," \t");
  for(i=0;i<17;i++)
    strtok(NULL," \t");
  return(atoi(strtok(NULL," \t")));
}
