/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <goffioul@imec.be>
 *
 *  $Id: kmdriverdialog.cpp,v 1.2 2001/03/24 07:27:49 waba Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 **/

#include "kmdriverdialog.h"
#include "driverview.h"

#include <klocale.h>

KMDriverDialog::KMDriverDialog(QWidget *parent, const char *name)
: KDialogBase(KDialogBase::Swallow,i18n("Configure"),KDialogBase::Ok|KDialogBase::Cancel,KDialogBase::Ok,parent,name,true,false)
{
	m_view = new DriverView(0);
	setMainWidget(m_view);

	resize(400,450);
}

KMDriverDialog::~KMDriverDialog()
{
}

void KMDriverDialog::setDriver(DrMain *d)
{
	m_view->setDriver(d);
}
