/* This file is Copyright 1993 by Clifford A. Adams */
/* svfile.c
 *
 * virtual scan mode file code
 */

/* trim the list */
#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "artio.h"
#include "cache.h"
#include "bits.h"
#include "final.h"
#include "intrp.h"
#include "search.h"
#include "ng.h"
#include "ngdata.h"
#include "trn.h"
#include "term.h"
#include "util.h"
#include "url.h"
#include "sgroup.h"
#include "sgdata.h"
#include "svirt.h"
#include "svdata.h"
#include "INTERN.h"
#include "svfile.h"

/* was a "begin virtual" found in the file? */
static bool sv_found_file = FALSE;

/* if TRUE, add groups, otherwise subtract them. */
static bool sv_pat_add = TRUE;

/* code copied and lightly modified from sgfile.c */

bool sv_match_err	INIT(FALSE);

/* Wildmat function:
 *      Based on Rich $alz's wildmat, reduced to the simple case of *
 *      and text.  The complete version can be found in Rich's INN,
 *      among other places; write to <rsalz@uunet.uu.net>
 */

/* an improbable number */
#define ABORT			-42

/*
**  Match text and p, return TRUE, FALSE, or ABORT.
*/
static int
sv_DoMatch(text, p)
register char	*text;
register char	*p;
{
    register int	matched;

    for ( ; *p; text++, p++) {
	if (*p == '*') {
	    while (*++p == '*')
		/* Consecutive stars act just like one. */
		continue;
	    if (*p == '\0')
		/* Trailing star matches everything. */
		return TRUE;
	    while (*text)
		if ((matched = sv_DoMatch(text++, p)) != FALSE)
		    return matched;
	    return ABORT;
	}
	if (*text != *p) {
	    if (*text == '\0')
		return ABORT;
	    return FALSE;
	}
    }
    return *text == '\0';
}

/* consider: if input found, just quickly add groups in a way that
 * they can later be refreshed.
 */
void
sv_use_pattern(pattern)
char *pattern;
{
    long i;
    char *s = pattern;

    sv_match_err = FALSE;		/* no errors (yet :-) */

    if (!s || !*s) {
	printf("\nvirtual scan pattern: empty regular expression\n") FLUSH;
	return;
    }
    for (i=0;i<sg_num_groups;i++) {
	if (int_count)
	    return;
	if (sv_DoMatch(sg_groups[i].name,pattern) == TRUE) {
		sv_use_group(sg_groups[i].name,sv_pat_add);
#ifdef PENDING
	    if (input_pending()) {
		return;
	    }
#endif
	}
    }
}

/* interprets a line of newsgroups, adding each pattern */
/* Newsgroup patterns are separated by spaces and/or commas */
void
sv_use_group_line(line)
char *line;
{
    char *s,*p;
    char ch;

/*    printf("sv_use_group_line(%s) called\n",line); /* */
    s = line;
    if (!s || !*s)
	return;
    while (*s) {
	if (int_count)
	    return;	/* pass up the chain */
	for (p=s;*p && ((*p != ' ') && (*p != ',')) ;p++)
	    ; /* EMPTY */
	ch = *p;
	*p = '\0';
	sv_use_pattern(s);
	*p = ch;
	s = p;
	while ((*s == ' ') || (*s == ','))
	    s++;
    }
}

/* returns filename after interpreting special stuff like :name */
/* also grabs URLs and translates them into temporary filenames */
/* returns a saved string, or Nullch on an error */
char *
sv_interp_fname(fname)
char *fname;
{
    char *s,*p;
    int i;
    bool flag;
    static char lbuf[LBUFLEN];

    if (!strncasecmp(fname,"URL:",4)) {
#ifdef USEURL
	s = temp_filename();
	flag = url_get(fname+4,s);
	if (flag) {
	    return(s);
	} else
	    return(NULL);
#else
	printf("This copy of strn does not have URL support.\n") FLUSH;
	return(NULL);
#endif
    }
    s = fname;
    if (*s == ':') {	/* relative to last file's directory */
	if (sg_num_contexts==0) {
	    /* this could happen if a virtual group is started
	     * from the article level.
	     */
	    printf("\nsv_include_file: top level filename error\n") FLUSH;
	    printf("(:file found without group scan context)\n") FLUSH;
	    printf("Ignoring...\n") FLUSH;
	    return(Nullch);
	}
	p = sg_contexts[sg_num_contexts-1].filename;
	for (i=sg_num_contexts-1;i>=0;i--)
	    if ((p=sg_contexts[i].filename))	/* EQUALS */
		break;
	if (i<0) {	/* no file found */
#ifdef UNDEF
	    printf("\nsv_include_file internal error: current not found\n")
		FLUSH;
#endif
	    return(Nullch);
	}
	strcpy(lbuf,p);
	p = rindex(lbuf,'/');
	if (!p) {
	    printf("\nsv_include_file: current location has no slash\n") FLUSH;
	    return(Nullch);
	}
	p++;					/* point to after slash */
	strcpy(p,s+1);
	return(savestr(lbuf));
    }
    return(savestr(s));
}


bool
sv_include_file(fname,remove)
char *fname;
bool_int remove;		/* if TRUE, remove temporary files */
{
    static char lbuf[LBUFLEN];
    FILE *fp;
    char *s;

    sv_begin_found = FALSE;
    s = fname;
/*  printf("\nAttempting to open file %s\n",s) FLUSH; /* */
    fp = fopen(filexp(s),"r");
    if (!fp) {
	strcpy(lbuf,filexp(s));
	if (strEQ(lbuf,filexp("%p/hotlist.strn"))) {
	    printf("The hotlist could not be opened");
	    printf(" (it was probably empty).\n") FLUSH;
	} else
	    printf("Could not open file %s\n",lbuf) FLUSH;
	return(FALSE);		/* unsuccessful */
    }
    int_count = 0;	/* reset interrupt counter */
/* Later consider long lines and backslash continuations */
    while ((s = fgets(lbuf,1020,fp))) {		/* EQUALS */
	if (!s)		/* end of file */
	    break;
	sv_do_line(s);
	if (int_count) {	/* user interrupt */
	    int_count = 0;
	    break;		/* stop including file */
	}
#ifdef PENDING
	if (input_pending())
	    break;
#endif
    }
    fclose(fp);
    /* if a group is open, close it (call does nothing otherwise) */
    sv_close_group(TRUE);	/* do any changed newsrc */
    /* perhaps delete invalid entries later (like in group scan mode) */
    sv_begin_found = FALSE;
    if (remove && strnEQ(fname,"/tmp/strn",9)) {
	UNLINK(fname);
    }
    return(TRUE);
}

/* returns TRUE on success, FALSE otherwise */
bool
sv_use_file(fname,title)
char *fname;		/* file name */
char *title;		/* for top bar */
{
    char *s;
    bool flag;

    (void)sv_new_context();
    sv_contexts[sv_num_contexts-1].title = savestr(title);

    s = sv_interp_fname(fname);
    if (!s)
	return(FALSE);
    sv_contexts[sv_num_contexts-1].filename = s;	/* already saved */

    sv_found_file = FALSE;	/* nothing found yet */
    flag = sv_include_file(s,FALSE);
#ifdef PENDING
	if (input_pending()) {
	    printf("Interrupted by user input.\n") FLUSH;
	    printf("Please wait one moment...\n") FLUSH;
	    eat_typeahead();
	}
#endif
    if (!sv_found_file) {
	if (flag) {	/* the file was opened OK */
	    if (strEQ(fname,"%p/hotlist.strn"))
		printf("The hotlist does not contain \"begin virtual\".\n")
		  FLUSH;
	    else
		printf("No begin virtual found in file.\n");
	}
	    (void)get_anything();
	    eat_typeahead();
	    /* the level that called this one will deal with the empty vgr */
    }
    sv_found_file = FALSE;
    return(TRUE);
}

void
sv_do_line(line)
char *line;
{
    char *s;
    char *p;
    ART_NUM a;

    s = line;

    if (!s || !*s)
	return;
    if (s[strlen(s)-1] == '\n')
	s[strlen(s)-1] = '\0';		/* delete newline */
    while ((*s == ' ') || (*s == '\t'))
	s++;		/* delete whitespace */

    if (!sv_begin_found) {
	if (!strnEQ(s,"begin virtual",13))
	    return;		/* beginning not found */
	sv_begin_found = TRUE;
	sv_found_file = TRUE;
	return;
    }
    if (sv_line_desc) {
	free(sv_line_desc);
	sv_line_desc = (char*)NULL;
    }

    if (*s == '"') {	/* description name */
	/* try handling backslashes later?  Perhaps other special cases? */
	s++;
	for (p=s;*p && *p != '"';p++)
	    ;	/* EMPTY */
	if (!*p) {
	    printf("virtual scan: unfinished quote.  Line was:\n%s\n",
		   line) FLUSH;
	    return;
	}
	*p = '\0';
	sv_line_desc = savestr(s);
	*p = '"';
	++p;
	s = p;
    }
    while ((*s == ' ') || (*s == '\t'))
	s++;		/* delete whitespace */

    if (!*s)		/* empty line */
	return;
    switch (*s) {
	case '#':	/* comment */
	    break;
	case '+':	/* add something */
	    s++;
	    switch (*s) {
		case '<':	/* message-id */
		    a = sv_msgid_to_num(s);
		    if (a)
			(void)sv_add_article(a,Nullch);
		    return;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	/* article numbers within current group */
		    a = (ART_NUM)atoi(s);
		    if (a>0)
			(void)sv_add_article(a,Nullch);
		    return;
		default:
		    sv_pat_add = TRUE;
		    sv_use_group_line(s);
		    return;
	    }
	case '-':	/* subtract something (eventually) */
	    s++;
	    if (*s == '-') {
		/* hmmm...  Looks like a signature to me */
		/* compensate for leaving off the end virtual command */
		sv_begin_found = FALSE;
		return;
	    }
	    while ((*s == ' ') || (*s == '\t'))
		s++;		/* skip whitespace */
	    if (*s == '<') {
		sv_sub_id(s);
	    } else {
		sv_pat_add = FALSE;
		sv_use_group_line(s);
	    }
	    return;
	default:	/* some command */
	    sv_file_command(s);
	    return;
    }
}

void
sv_file_command(cmd)
char *cmd;
{
    char *s,*p;
    bool flag;
    long score;

    if (!cmd || !*cmd)
	return;
    s = cmd;
    /* terminate on either an explicit command or at the start of
     * a signature.  (Signature-catching may stop some common errors.)
     */
    if (strnEQ(s,"end virtual",11) || strnEQ(s,"--",2)) {
	sv_begin_found = FALSE;		/* start skiping lines again */
	return;
    }
    if (strnEQ(s,"score",5)) {
	s += 5;
	while (*s && (*s == ' ' || *s == '\t'))
	    s++;
	if (!*s) {
	    printf("virtual scan: empty line after score.\n") FLUSH;
	    printf("...line was |%s|\n",cmd) FLUSH;
	    return;
	}
	if (strnEQ(s,"min",3) || strnEQ(s,"max",3)) {
	    flag = (s[2] == 'x');	/* true if "max" */
	    s += 3;
	    while (*s && (*s == ' ' || *s == '\t'))
		s++;
	    if (!*s) {
		printf("virtual scan: score error.\n") FLUSH;
		printf("...line was |%s|\n",cmd) FLUSH;
		return;
	    }
	    if (strnEQ(s,"off",3)) {
		if (flag)
		    sv_f_maxused = FALSE;
		else
		    sv_f_minused = FALSE;
		return;
	    }
	    score = atoi(s);
	    if (flag) {
		sv_f_maxused = TRUE;
		sv_f_maxscore = score;
	    } else {
		sv_f_minused = TRUE;
		sv_f_minscore = score;
	    }
	} else {
	    printf("virtual scan: score command error.\n") FLUSH;
	    printf("...line was |%s|\n",cmd) FLUSH;
	}
	return;
    } /* if score */
    if (strnEQ(s,"group",5)) {
	s += 5;
	while (*s && (*s == ' ' || *s == '\t'))
	    s++;
	if (!*s) {
	    printf("virtual scan: empty line after group.\n") FLUSH;
	    printf("...line was |%s|\n",cmd) FLUSH;
	    return;
	}
	sv_go_group(s);
	return;
    } /* if group */
    if (strnEQ(s,"include",7)) {
	s += 7;
	while (*s && (*s == ' ' || *s == '\t'))
	    s++;
	if (!*s) {
	    printf("virtual scan: empty line after include.\n") FLUSH;
	    printf("...line was |%s|\n",cmd) FLUSH;
	    return;
	}
	p = sv_interp_fname(s);
	if (!p)
	    return;
	sv_include_file(p,TRUE);
	free(p);
	sv_begin_found = TRUE;		/* reset it */
	return;
    } /* if include */
    if (strnEQ(s,"filter",6)) {
	s += 6;
	while (*s && (*s == ' ' || *s == '\t'))
	    s++;
	if (!*s) {
	    printf("virtual scan: empty line after filter.\n") FLUSH;
	    printf("...line was |%s|\n",cmd) FLUSH;
	    return;
	}
	if (strnEQ(s,"unread+read",11)) {
	    sv_f_unread = FALSE;
	    return;
	}
	if (strnEQ(s,"unread",6)) {
	    sv_f_unread = TRUE;
	    return;
	}
	printf("virtual scan: filter command error.\n") FLUSH;
	printf("...line was |%s|\n",cmd) FLUSH;
	return;
    } /* if filter */
    if (strnEQ(s,"display",7)) {
	s += 7;
	while (*s && (*s == ' ' || *s == '\t'))
	    s++;
	if (!*s) {
	    printf("virtual scan: empty line after display.\n") FLUSH;
	    printf("...line was |%s|\n",cmd) FLUSH;
	    return;
	}
	if (strnEQ(s,"unread+read",11)) {
	    sv_e_unread = FALSE;
	    return;
	}
	if (strnEQ(s,"unread",6)) {
	    sv_e_unread = TRUE;
	    return;
	}
	if (strnEQ(s,"author",6)) {
	    sv_show_author = TRUE;
	    return;
	}
	if (strnEQ(s,"noauthor",8)) {
	    sv_show_author = FALSE;
	    return;
	}
	if (strnEQ(s,"group",5)) {
	    sv_show_groups = TRUE;
	    return;
	}
	if (strnEQ(s,"nogroup",7)) {
	    sv_show_groups = FALSE;
	    return;
	}
	printf("virtual scan: display command error.\n") FLUSH;
	printf("...line was |%s|\n",cmd) FLUSH;
	return;
    } /* if display */
}


/* edits the current file */
void
sv_edit_file()
{
    char *fname = Nullch;
    char *s;
    int i;
    char lbuf[1024];	/* hold the filename */
    char wherebuf[1024];	/* where were we? */

    for (i=sv_num_contexts-1;i>=0;i--)
	if ((fname=sv_contexts[i].filename))	/* EQUALS */
	    break;
    if (i<0) {	/* no file found */
	printf("\nThe current virtual group did not originate from a file.\n")
	  FLUSH;
	return;
    }
    if (!fname || !*fname)
	return;		/* empty, do nothing (error later?) */
    strcpy(lbuf,filexp(fname));
    sprintf(cmd_buf,"%s %s",
	filexp(getval("VISUAL",getval("EDITOR",defeditor))),lbuf);
    printf("\nEditing group scan topic file %s:\n%s\n",fname,cmd_buf) FLUSH;
    resetty();			/* make sure tty is friendly */
    getwd(wherebuf);	/* find out where we are */
    s = rindex(lbuf,'/');
    if (!s)
	return;		/* error, but not critical */
    if (s == lbuf)	/* wow, file in root directory */
	s++;		/* will need the slash */
    *s = '\0';	/* cut off after directory name */
    if (chdir(lbuf)) {
	printf(nocd,lbuf) FLUSH;
	return;
    }
    doshell(sh,cmd_buf);/* invoke the shell */
    if (chdir(wherebuf)) {
	printf(nocd,wherebuf) FLUSH;
	return;
    }
    noecho();			/* and make terminal */
    crmode();			/*   unfriendly again */
}

static long sv_our_pid = 0;

/* use article in "art" */
void
sv_use_article()
{
    static char fname[LBUFLEN];
    static char title[LBUFLEN];
    ART_NUM a;

    a = art;
    if (is_unavailable(art))
	return;
    sprintf(title,"%s", filexp("%s"));
#ifdef USE_NNTP
    if (!artopen(a))
	return;		/* be sure it is open and created */
    fclose(artfp);		/* close the article */
    artfp = Nullfp;
    openart = 0;
    if (sv_our_pid == 0)
	sv_our_pid = getpid();
    sprintf(fname, "/tmp/rrn.%ld", sv_our_pid);
#else
    sprintf(fname,"%s/%%c/%d",spool,a);
    strcpy(fname,filexp(fname));
#endif
    sv_close_current();
    sv_main(fname,title);
}
#endif /* SCAN */
