/* parse.c - simple C intepretor
   This has nothing to do with cryptography.
   Copyright (C) 1998 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  
 */

#ifndef _PARSER_H
#define _PARSER_H

#ifdef WIN32
#define PATH_SEP_STR "\\"
#define PATH_SEP '\\'
#else
#define PATH_SEP_STR "/"
#define PATH_SEP '/'
#endif

typedef struct {
/* on any sane system, these will all be of 
   size equal to or smaller than long int */
    union {
	char *s;
	long i;
	long *p;
	Huge *h;
    } v;
#define VALUE_LEN		(0x000FFFFF)
#define VALUE_LONG		(0x00100000)
#define VALUE_ENDVARARGS	(0x00200000)
#define VALUE_HUGE		(0x00400000)
#define VALUE_STRING		(0x00800000)
#define VALUE_POINTER		(0x0F000000)
#define VALUE_P0		(0x01000000)
#define VALUE_P1		(0x02000000)
#define VALUE_P2		(0x03000000)
#define VALUE_P3		(0x04000000)
#define VALUE_P4		(0x05000000)
#define VALUE_P5		(0x06000000)
#define VALUE_TYPE		(0x0FF00000)
#define VALUE_FREE		(0x10000000)
#define VALUE_END		(0x20000000)
    int type;
} Value;

typedef struct value_stack {
    Value value;
    struct value_stack *next;
} ValueStack;

typedef struct {
    int len;
    char *s;
    int priority;
/* predefined constants per instance of the script */
#define OP_PREDEF	40
/* user functions */
#define OP_USER_FUNCTION	90
/* functions */
#define OP_FUNCTION	50
/* builtin constants */
#define OP_CONSTANT	80
    int type;
    int whole_word;
    int (*func) ( /* OpStack **, ValueStack ** */ );
    Value *value;		/* for user constants, like strings and numbers */
    int nargs;			/* number of args for a function */
} Operator;

typedef int (*Func) ();

void parser_shut (void);
void parser_init (void);
int parser_add_operator (Operator * o);
Value parser_value_pop (ValueStack ** s);
void parser_push_int (ValueStack ** s, long i);
void parser_push_string (ValueStack ** s, char *str, int len);
void parser_push_string_free (ValueStack ** s, char *str, int len);
void parser_push_huge_free (ValueStack ** s, Huge * v);
void parser_value_push (ValueStack ** s, Value value);
void parser_value_free (Value v);

void parser_free (void *s, Value *heap);
void *parser_compile (char *text, Value *heap);
int parser_evaluate (void *s, void *user_data);

#endif	/* ! _PARSER_H */

