OSyncEngine *osengine_new(OSyncGroup *group, OSyncError **);
void osengine_free(OSyncEngine *engine);

void osengine_calculate_flags(OSyncEngine *engine);
void osengine_client_all_deciders(OSyncEngine *engine);
void osengine_decider(OSyncEngine *engine);
void osengine_client_decider(OSyncEngine *engine, OSyncClient *client);
void osengine_changes_done(OSyncEngine *engine, OSyncMember *member);
osync_bool osengine_init(OSyncEngine *engine, OSyncError **);
void osengine_finalize(OSyncEngine *engine);
void osengine_flag_only_info(OSyncEngine *engine);
osync_bool osengine_synchronize(OSyncEngine *engine, OSyncError **);
void osengine_pause(OSyncEngine *engine);
void osengine_abort(OSyncEngine *engine);
osync_bool osengine_wait_sync_end(OSyncEngine *engine, OSyncError **error);
void osengine_wait_info_end(OSyncEngine *engine);
void osengine_one_iteration(OSyncEngine *engine);
void osengine_flag_manual(OSyncEngine *engine);
void osengine_set_message_callback(OSyncEngine *engine, void *(* function) (OSyncEngine *, OSyncClient *, const char *, void *, void *), void *user_data);
void osengine_set_conflict_callback(OSyncEngine *engine, void (* function) (OSyncEngine *, OSyncMapping *, void *), void *user_data);
void osengine_set_changestatus_callback(OSyncEngine *engine, void (* function) (OSyncEngine*, OSyncChangeUpdate *, void *), void *user_data);
void osengine_set_mappingstatus_callback(OSyncEngine *engine, void (* function) (OSyncMappingUpdate *, void *), void *user_data);
void osengine_set_enginestatus_callback(OSyncEngine *engine, void (* function) (OSyncEngine *, OSyncEngineUpdate *, void *), void *user_data);
void osengine_set_memberstatus_callback(OSyncEngine *engine, void (* function) (OSyncMemberUpdate *, void *), void *user_data);
osync_bool osengine_sync_and_block(OSyncEngine *engine, OSyncError **error);
OSyncMapping *osengine_mapping_from_id(OSyncEngine *engine, long long id);
