DACS(1)                      DACS Commands Manual                      DACS(1)



[1mNAME[0m
       dacs - a distributed access control system

[1mSYNOPSIS[0m
       [1mdacs [22m[[1m-v [22m| [1m--verbose[22m] [[1m--dumpenv[22m] [[1m--license[22m] [[1m--version[22m]

       [1mdacs [4m[22mdacs-command[24m [[34m[1mdacsoptions[0m[1m[22m[1]] [...]

       [4mdacs-command[24m [[1m-u [4m[22muri-prefix[24m | [1m-uj [4m[22mjurisdiction-name[24m | [1m-un [22m| [1m-us[22m]
                    [[1m-c [4m[22mdacs.conf[24m]
                    [[1m-sc [4m[22msite.conf[24m] [[1m-ll [4m[22mlogging-level[24m] [[1m-format [4m[22mfmt[24m] [[1m-q[22m]
                    [[1m-t[22m] [[1m-D[4m[22mname[24m[1m=[4m[22mvalue[24m]
                    [[1m-v [22m| [1m--verbose[22m] [[1m--dumpenv[22m] [[1m--enable-dump[22m] [[1m--license[22m]
                    [[1m--std[22m] [[1m--version[22m]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       [1mDACS [22mis a general-purpose, Web-based authentication and access control
       system. It provides single sign-on functionality and flexible access
       control to content and services provided by web servers.  [1mDACS [22mconsists
       of an [1mApache [22mmodule ([34m[1mmod_auth_dacs[0m[1m[22m[2]) through which [1mApache[0m
       communicates with [1mDACS [22mto make access control decisions, a suite of CGI
       programs that provide [1mDACS [22mweb services, and a collection of utility
       commands that provide various support and administrative functions for
       [1mDACS[22m. Some of these utilities, such as [34m[1mhttp(1)[0m[1m[22m[3] and [34m[1msslclient(1)[0m[1m[22m[4],
       are completely general-purpose.

       The [1mDACS [22maccess control engine and authentication components can also
       be used from the command line, within a CGI environment or completely
       independently of the Web.

       For important information about [1mDACS[22m, including installation
       instructions, please see [34m[1mdacs.readme(7)[0m[1m[22m[5] and [34m[1mdacs.install(7)[0m[1m[22m[6].

   [1mAbout DACS[0m
           [1mNO WARRANTY[0m
           This software is provided by Dss "as is" and any express or implied
           warranties, including, but not limited to, the implied warranties
           of merchantability, fitness for a particular purpose, or
           non-infringement, are disclaimed. In no event shall Dss be liable
           for any direct, indirect, incidental, special, exemplary, or
           consequential damages (including, but not limited to, procurement
           of substitute goods or services; loss of use, data, or profits; or
           business interruption) however caused and on any theory of
           liability, whether in contract, strict liability, or tort
           (including negligence or otherwise) arising in any way out of the
           use of this software, even if advised of the possibility of such
           damage.

       By convention, the names of all [1mDACS [22mweb services begin with the prefix
       "dacs_" (e.g., [1mdacs_conf[22m). Starting with release 1.4.17, all commands
       that implement [1mDACS [22mfunctionality begin with the prefix "dacs" (e.g.,
       [1mdacsconf[22m). Many [1mDACS [22mweb services have command analogues. The names of
       web services that are used internally by [1mDACS [22m(i.e., they are never
       called directly by users) begin with "local_" (e.g.,
       [1mlocal_passwd_authenticate[22m). General-purpose web services and commands
       do not follow a naming convention, other than not using any of the
       previously mentioned prefixes.

       The document type definitions (DTDs) that are maintained in the dtd-xsd
       directory are used to document file formats or describe the arguments
       to a [1mDACS [22mweb service or its reply. In the current implementation,
       these DTD files are not used during XML validation. Attributes of type
       CDATA may have additional constraints on their values; consult the
       relevant documentation. The files are technically not valid DTDs,
       because they lack a document type declaration (DOCTYPE); an appropriate
       DOCTYPE is generated programmatically at the time a DTD is emitted.

           [1mImportant[0m
           [1mDACS [22mdoes not prevent certain kinds of attacks against web sites,
           such as [34m[1mDenial of service attacks[0m[1m[22m[7], [34m[1mCross-site scripting (XSS)[0m[1m[22m[8]
           or [34m[1mCross-site request forgery (CSRF)[0m[1m[22m[9]. When combined with
           appropriate web site protective measures, however, [1mDACS [22mdoes
           provide mechanisms to make these types of attacks more difficult.

   [1mAbout the Manual Pages[0m
       The technical documentation for [1mDACS [22mconsists of a set of manual pages.
       In the HTML collection, an [34m[1mindex page[0m[1m[22m[10] includes a table of contents,
       links to special annotations within the technical documentation, and
       lists of variables, configuration directives, and XML Document Type
       Definitions.

           [1mTip[0m
           Each HTML manual page contains a font size selection tool near its
           bottom. If JavaScript is enabled, the currently selected font size
           can be changed and a global preference set. To choose a font size
           for the current page, click on one of the four boxes. To make the
           current selection your preference across manual pages, site visits,
           and browser sessions, click on the "set" button, which will set an
           HTTP cookie. If a preference has not been set in this way (i.e.,
           there is no cookie) and a manual page is visited with the query
           parameter [4mDACSMANFONT[24m set to 0, 1, 2, or 3 (representing smallest
           to largest point sizes), the corresponding font will be selected
           and the preference automatically set (if a preference has been set,
           the parameter is ignored).

       Areas of the documentation labeled "Security" discuss important
       security considerations; please pay special attention to them. Areas
       labeled "Tip" provide pointers to time-saving (and sometimes
       aggravation-reducing) techniques and recommended practices.

       In pathnames and URLs that appear in examples, the text "..."
       represents text that has been omitted because it is not relevant to the
       discussion at hand, or which may vary depending on configuration
       details, such as where something has been installed (e.g.,
       .../dacs/bin/http).

       Unless otherwise stated, URLs used in examples are fictitious and most
       likely will not work. The reserved domain name example.com is often
       used ([34m[1mRFC 2606[0m[1m[22m[11]).

       In instructions and examples, a '%' is generally used to signify a
       command line prompt:

           % date
           Sun Apr  1 15:33:11 PDT 2007

       Sometimes another character is used to signify a prompt, however, such
       as when demonstrating the interactive mode of [34m[1mdacsexpr(1)[0m[1m[22m[12]:

           > 1 + 1
           2

       An extended form of [34m[1mBNF notation[0m[1m[22m[13] is used to describe syntax
       concisely. We hope it is both understandable and familiar, but some
       inconsistencies and ambiguities may occur throughout the documentation;
       this is being improved slowly. A term in a production may include a
       regular expression type specification, with '+' meaning one or more
       occurrences of the term, and '*' zero or more occurrences. Any one of a
       set of characters is specified within square brackets, and a range of
       consecutive characters (in ASCII code sequence) is separated by a
       hyphen (e.g., [A-Za-z0-9\-_]+ means "one or more alphabetic characters,
       digits, hyphens, or underscores"). In other contexts, square brackets
       indicate an optional term. Single and double quotes specify literal
       characters. Note that XML DTDs use their own syntax, which is somewhat
       different, and in some cases grammars followed in relevant RFCs are
       respected for clarity or in examples.

   [1mKey Concepts[0m
       Some of the key concepts used throughout the [1mDACS [22mdocumentation are
       defined in this section.


       [4maccount[0m
           A persistent record that associates an identity (or username) with
           state information about the account (such as whether the account is
           enabled or disabled), information that is required to authenticate
           the identity (such as a digest of a password string), and possibly
           other sign-on related information. Note that [1mDACS [22midentities do not
           necessarily have a corresponding account.  [1mDACS [22mdoes not provide
           mechanisms to administer "foreign" account types; for instance,
           although it can authenticate against them, it cannot create or list
           Unix or Windows accounts.

       [4mauthentication[0m
           The procedure by which a person or program obtains credentials that
           represent a [1mDACS [22midentity, usually by asserting a [1mDACS [22musername
           that represents an identity and providing information that only
           that identity is likely to know or possess. After successful
           authentication, a person or program is said to have authenticated.
           [1mDACS [22mcan interface with a wide variety of authentication methods
           and provides some of its own; new methods can easily be added.

       [4mauthorization[0m
           The procedure that determines, in a particular context, whether a
           request for a given resource or object should be allowed. If an
           identity is authorized to perform a certain operation on the
           object, access is granted, otherwise it is denied. Access control
           rules are one method of describing which identity or identities
           should be granted - or denied - access to a particular resource.
           Coarse-grained access control involves making a high-level decision
           of whether access to an object should be granted; this is usually
           an all-or-nothing decision. Fine-grained access control is used
           within a program to decide whether access to a lower-level resource
           (some data, an administrative function, a menu) should be granted.

           Note that unlike some systems, [1mDACS [22mdoes not predetermine which
           resources a particular user (identity) can and cannot access; that
           is, an administrator does not make a list of what rights each user
           has. Authorization is always determined by rule evaluation, in real
           time, when a user requests a resource. The only exemptions to this
           are some optional features: [34m[1mAuthorization Caching[0m[1m[22m[14] and
           [34m[1mRlinks[0m[1m[22m[15].

       [4mcredentials[0m
           If [4mauthentication[24m is successful, [1mDACS [22mreturns information that can
           be used in subsequent operations to represent the authenticated
           identity. Credentials contain information about the identity, such
           as its name, and meta information, such as the time at which the
           credentials expire and become invalid. Credentials are protected
           cryptographically so that they are difficult to forge or alter.
           They must be kept secret, so that the identity cannot be used by
           anyone other than its owner, and must accompany a request made to a
           server so that [1mDACS [22mknows who is making the request. The particular
           mechanism used for this is not important provided credentials
           cannot be copied and reused; transporting credentials using the
           payload of an HTTP cookie over an SSL connection is typical,
           although sending credentials as the value of an HTTP extension
           header is another possibility.

           Although there is no specific limit on the size of credentials as
           far as [1mDACS [22mis concerned, since they can be encapsulated within an
           HTTP cookie and returned to a browser, constraints on cookies
           imposed by browsers should be carefully considered.

           Any jurisdiction can understand credentials produced by any other
           jurisdiction within the same federation. Therefore, a user only
           needs to be authenticated once to access web services at any
           jurisdiction using that identity.

           Note that in [1mDACS[22m, credentials do not give their owner any rights
           or convey any authorization; [1mDACS [22mis not a [34m[1mcapability-based[0m
           [1m[34msystem[0m[1m[22m[16]. Credentials simply represent a [1mDACS [22midentity.

           Refer to [34m[1mdacs_authenticate(8)[0m[1m[22m[17] for details.

       [4mcurrent[24m [4mrequest[0m
           The event that has triggered the authorization check being
           processed by [34m[1mdacs_acs(8)[0m[1m[22m[18] is referred to as the current request.
           For a request for a [1mDACS[22m-wrapped web resource, this will be the
           HTTP request that is received by the web server for the resource.
           In situations where [1mdacs_acs [22mis not involved, such as when
           [34m[1mdacscheck(1)[0m[1m[22m[19] or [34m[1mdacsexpr(1)[0m[1m[22m[12] are used, the current request
           and its context are specified by command line arguments or are
           obtained from the [34m[1mexecution environment[0m[1m[22m[20].

           [1mdacs_acs [22muses [4m${DACS::URI}[24m as the path component of the current
           request. It is obtained from Apache's [4muri[24m element of the current
           request_rec. This is the string that is used to match against
           access control rules.

           Other [1mDACS [22mcomponents determine the current HTTP request by
           examining several environment variables: [1mHTTP_HOST [22m(or [1mSERVER_NAME[0m
           and [1mSERVER_PORT[22m), [1mREQUEST_URI[22m, [1mQUERY_STRING[22m, and [1mHTTPS[22m.

           The value of [4m${DACS::URI}[24m and the path component of
           [4m${Env::REQUEST_URI}[24m are not necessarily the same. After an internal
           redirect, for example, the latter's value is from the original URL,
           while the former's is from the target of the redirection.

           The current request string is important because it may be used to
           determine the [34m[1mcurrent federation[0m[1m[22m[21] and [34m[1mcurrent jurisdiction[0m[1m[22m[22],
           and because it is used when searching for the access control rule
           to apply to the request.

       [1mDACS[0m
           Consisting of CGI-based web services, an [1mApache [22m2.0/2.2 module, and
           a collection of utilities, [1mDACS [22mprovides authentication and
           authorization functionality. Transparent, coarse-grained role-based
           access control is available for web resources.

           Programmatic, general-purpose role-based access control is
           available for virtually any program (using [34m[1mdacscheck(1)[0m[1m[22m[19]). This
           is completely decoupled from Apache.

       [1mDACS [4m[22madministrator[0m
           An individual (or individuals) responsible for managing the
           operation of [1mDACS [22mis called a [1mDACS [22madministrator (sometimes just
           "the administrator"). This individual is not necessarily a system
           administrator (e.g., superuser or root), although a small number of
           optional components of [1mDACS [22mmust execute as user or group root. The
           [1mDACS [22madministrator need not be an [1mApache [22madministrator; once [1mApache[0m
           has been configured for [1mDACS [22mit typically requires very few
           modifications thereafter. The [1mDACS [22madministrator is responsible for
           configuring and testing [1mDACS [22m(probably installing and upgrading it,
           too), managing user accounts and access control rules, safeguarding
           security, backing up configuration and data files, and so on. The
           design of [1mDACS [22mallows some delegation of responsibility, largely
           based on file permissions. When invoked as a web service, each of
           the identities configured as a [34m[1mADMIN_IDENTITY[0m[1m[22m[23] is effectively a
           [1mDACS [22madministrator; in this context, the system superuser has no
           significance.

       [1mDACS [4m[22midentity[0m
           Each authenticated user is assigned a name that consists of the
           name of the authenticating jurisdiction, its federation name, and a
           username. Each of these naming components must be syntactically
           correct. In some contexts the federation name is implicit;
           sometimes the jurisdiction name is also implicit. Entities such as
           individuals (people, but also programs, devices, etc.),
           federations, jurisdictions, and groups have names. It is the
           responsibility of jurisdictions to authenticate users. The syntax,
           meanings, and uniqueness of names is also a jurisdictional issue,
           and perhaps a federation-wide issue as well.

           Each real world entity typically has a unique [1mDACS [22midentity, but
           this is left up to authenticating jurisdictions. Two or more
           identities are distinct if they do not refer to the same real world
           individual.  Federated identity or single sign-on (SSO) is the
           ability to recognize a user identity across jurisdictions and even
           across federations.

               [1mImportant[0m
               Keep in mind that regardless of the authentication method and
               account information used, two identical usernames (relative to
               the same jurisdiction and taking into account [34m[1mNAME_COMPARE[0m[1m[22m[24])
               are [4mimplicitly[24m [4massumed[24m [4mto[24m [4mrefer[24m [4mto[24m [4mthe[24m [4msame[24m [4midentity[24m by [1mDACS[22m.
               For instance, someone who authenticated as auggie by providing
               the correct Unix password is virtually indistinguishable from
               someone who authenticated as auggie using an Information Card.
               User credentials include information about the authentication
               method involved in their creation and the [34m[1muser()[0m[1m[22m[25] function
               can be used to obtain this information, but it would be unwise
               to base identities on this. It is strongly advised that a new
               [1mDACS [22mjurisdiction carefully develop an extensible plan for user
               naming.

       [1mDACS[22m-[4mwrapped[0m
           A web resource is said to be [1mDACS[22m-wrapped if the web server
           responsible for the resource calls [1mDACS [22m(more specifically,
           [34m[1mdacs_acs(8)[0m[1m[22m[18]) to make an access control decision whenever it
           receives a request for the resource.

       [4mfederation[0m
           A [1mDACS [22mfederation consists of one or more jurisdictions. The
           jurisdictions comprising a federation coordinate information
           sharing through light-weight business practices implemented as a
           requirement of membership in a [1mDACS [22mfederation; in other words, the
           members of a federation typically agree to observe certain rules of
           conduct to preserve overall security and so that users can obtain
           maximum benefit. A federation consisting of just one jurisdiction
           is not unusual.

       [4mitem[24m [4mtype[0m
           An item type is a name that maps to a [34m[1mVFS[0m[1m[22m[26] (virtual filestore)
           specification that configures how and where data is stored. The
           level of indirection that they provide means that access control
           rules, for example, can be configured to be in regular files, a
           Berkeley DB database, a remote database accessed by HTTP, and so on
           - all that is required is that the item type acls be properly
           configured. Some item types (like acls) are reserved and have
           special meaning to [1mDACS[22m, while others can be used by a [1mDACS[0m
           administrator for other purposes. An item type name is case
           sensitive and consists of alphanumerics, hyphens, and underscores,
           but must begin with an alphabetic character.

       [4mjurisdiction[0m
           A [1mDACS [22mjurisdiction is an autonomous administrative entity that
           authenticates its users, provides web services, or both. It may
           correspond to an organization, department, web server, or virtual
           host. Jurisdictions are sometimes created simply as an
           administrative convenience. Each jurisdiction is assigned a unique
           name within a federation.

           A user's home jurisdiction is a jurisdiction that can authenticate
           that user. In situations where a user has multiple credentials
           obtained from different jurisdictions, the effective home
           jurisdiction for a request depends on which credentials are
           selected during authorization processing. Configuration directives
           are available to restrict the number of sets of credentials that
           may accompany a request.

       [4muser[24m [4magent[0m
           A user agent is client-side software that interacts with other
           software (a server application, typically) on behalf of a [4muser[24m. A
           user is often a person but can also be software. A web browser,
           which is used to interact with a web server, is an example of a
           user agent.

   [1mNaming[0m
       [1mDACS [22mneeds to name a variety of things so that they can be referred to
       in expressions, access control rules, configuration directives, and so
       on. While the URI syntax is used to name some kinds of objects within
       [1mDACS[22m, [1mDACS [22malso has its own concise naming schemes.

           [1mNote[0m
           The terms current federation (current jurisdiction) and this
           federation (this jurisdiction) are used in the documentation to
           refer to the federation (jurisdiction) associated with the
           configuration context in effect while [1mDACS [22mprocesses a request.

           In general, the [4mfederation-name[24m component of a name is optional; if
           absent, the current federation is assumed. Similarly, the
           [4mjurisdiction-name[24m may be elided and the current jurisdiction is
           implied.

       Federations
           Syntax:

               [4mfederation-name[24m::

           Example:

               DEMO::

           The [4mfederation-name[24m (usually obtained from a [34m[1mFEDERATION_NAME[0m[1m[22m[27]
           configuration directive) must begin with an alphabetic character
           and is followed by zero or more alphanumerics, hyphens, and
           underscores. A [4mfederation-name[24m is ordinarily treated case
           sensitively (but see the [34m[1mNAME_COMPARE[0m[1m[22m[24] configuration directive
           and the [34m[1muser()[0m[1m[22m[25] function for alternate behaviours). There is no
           [4ma[24m [4mpriori[24m limit on its length.

           The [34m[1mFEDERATION_DOMAIN[0m[1m[22m[28] directive specifies the domain name
           suffix common to all jurisdictions in a federation.

       Jurisdictions
           Syntax:

               [[[4mfederation-name[24m:: | [::]] [4mjurisdiction-name[24m:

           Examples:

               DEMO::DSS:
               ::DSS:
               DSS:

           The [4mjurisdiction-name[24m (usually obtained from a
           [34m[1mJURISDICTION_NAME[0m[1m[22m[29] configuration directive) must begin with an
           alphabetic character and is followed by zero or more alphanumerics,
           hyphens, and underscores. A [4mjurisdiction-name[24m is ordinarily treated
           case sensitively (but see the [34m[1mNAME_COMPARE[0m[1m[22m[24] configuration
           directive and the [34m[1muser()[0m[1m[22m[25] function for alternate behaviours).
           There is no [4ma[24m [4mpriori[24m limit on its length.

       Users
           Syntax:

               [[[[4mfederation-name[24m:: | [::]] [4mjurisdiction-name[24m]:[4musername[0m

           Examples:

               DEMO::DSS:auggie
               ::DSS:auggie
               DSS:auggie
               :auggie

           A full [1mDACS [22midentity includes a federation name component and a
           jurisdiction name component, in addition to the [4musername[24m. It is
           provided to [1mDACS[22m-wrapped programs as the value of the
           [34m[1mDACS_IDENTITY[0m[1m[22m[30] environment variable.

           The username component, which is available to CGI programs as the
           value of the [34m[1mDACS_USERNAME[0m[1m[22m[31] environment variable, consists of
           one or more ASCII characters from the set of upper and lower case
           alphabetics, digits, and the following punctuation characters:

               ! # $ % & ' - . ; ? @ [ ^ _ ` { }

           All characters having a value less than 041 (octal) or greater than
           0176 (octal) are [4minvalid[24m, as are the following characters:

               * , : + ( ) ~ < > = | \ / "


               [1mNotes[0m
               +o   In addition to the alphanumeric characters, [34m[1mRFC 2396[0m[1m[22m[32]
                   allows only the following characters ("[4mpchar[24m") to appear in
                   the path component of a URI:

                       - _ . ! ~ * ' ( ) % : @ & = + $ ,


               +o   Some valid email addresses are not valid [1mDACS [22musernames.
                   For example, *bob*@example.com, "(bob)"@example.com, and
                   \(bob\)@example.com are valid mailbox names as defined by
                   [34m[1mRFC 822[0m[1m[22m[33] (Appendix D) and discussed in [34m[1mRFC 3696[0m[1m[22m[34]
                   (Section 3), but both are invalid as [1mDACS [22musernames. Unless
                   quoted, the local-part component of an email address, which
                   precedes the "@" character in the addr-spec, may not
                   contain any of:

                       ( ) <  > @ , ; : \ " . [ ]

                   Additionally, the space and all US-ASCII control characters
                   (octets 0 - 31) and DEL (127) are disallowed. Without
                   quotes, the local-part may consist of any combination of
                   alphabetics, digits, or any of the following characters:

                       ! # $ % & ' * + - / = ?  ^ _ ` . { | } ~

                   A period (".") may be used, but may not start or end the
                   local-part, nor may two or more consecutive periods appear.
                   Within double quotes, any ASCII character may appear if
                   properly quoted (e.g., Auggie."
                   ".O."\'".Doggie@example.com). The maximum length of the
                   local-part is 64 characters, and the maximum length of the
                   domain component that appears after the "@" character is
                   255 characters.

                   There is currently no way to "quote" a [1mDACS [22musername, so
                   some safe encoding method or transformation must be applied
                   to these names.

               +o   [1mDACS [22mmay create identities for internal use having username
                   components that include characters that are normally
                   invalid.

               +o   A [4musername[24m is case sensitive (but see the [34m[1mNAME_COMPARE[0m[1m[22m[24]
                   configuration directive and the [34m[1muser()[0m[1m[22m[25] function for
                   alternate behaviours). There is no [4ma[24m [4mpriori[24m limit on its
                   length.

               +o   The recommended practice is for jurisdictions to map their
                   [1mDACS [22musernames to lower case during the authentication
                   procedure where possible and when the mappings are unique.
                   The [34m[1mEXIT*[0m[1m[22m[35] directive may be used for this purpose.

           Groups
               Syntax:

                   [[[4mfederation-name[24m:: | [::]] %[[4mjurisdiction-name[24m]:[4mgroupname[0m

               A [4mgroupname[24m must begin with an alphabetic character and may be
               followed by any number of alphanumeric, hyphen ("-"), and
               underscore ("_") characters.

               Examples:

                   %DEMO::DSS:friends
                   %::DSS:friends
                   %DSS:friends
                   %:friends


           Roles and Role Descriptors
               Syntax:

                   [4mRole-Descriptor[24m -> [4mEmpty-String[24m | [4mRole-List[0m

                   [4mRole-List[24m       -> [4mRole[24m | [4mRole[24m "," [4mRole-List[0m

                   [4mRole[24m            -> [4mBasic-Role[24m | [4mComposite-Role[0m

                   [4mBasic-Role[24m      -> [A-Za-z0-9\-_]+
                   [4mComposite-Role[24m  -> [4mBasic-Role[24m "/" [4mBasic-Role[24m | [4mBasic-Role[24m "/" [4mComposite-Role[0m

                   [4mEmpty-String[24m    -> ""

               A role descriptor string (also called a role string or a role
               descriptor) consists of a comma separated list of roles. The
               name of a role (a [4mBasic-Role[24m) is constructed from upper and
               lower case letters, digits, hyphens, and underscores. A
               [4mComposite-Role[24m is constructed from two or more [4mBasic-Role[0m
               terms, separated by a slash character. Here are three examples
               of a role descriptor:

                   admin,wheel,root
                   admin/hardware
                   networks/programming,computer-science/systems/Project_X


                   [1mNote[0m
                   A role descriptor string contains no white space characters
                   and may not begin or end with a comma or slash character.
                   Two or more consecutive commas are illegal, as are two or
                   more consecutive slashes.
               The [34m[1msetvar()[0m[1m[22m[36] function can be used to separate a composite
               role into its basic roles.

               Please refer to [34m[1mdacs.groups(5)[0m[1m[22m[37] for additional information.

           Concise User Syntax
               Syntax:

                   [4mident[24m     -> '{' [4mkwv-list[24m '}' | [4muser[0m
                   [4mkwv-list[24m  -> [4mkwv[24m [',' [4mkwv[24m]*
                   [4mkwv[24m       -> [4mkwv-user[24m | [4mkwv-group[24m | [4mkwv-attr[24m | [4mkwv-ip[24m | [4mkwv-expires[0m
                   [4mkwv-user[24m    -> 'u=' [Q] [4muser[24m [Q]
                   [4mkwv-group[24m   -> 'g=' [Q] [4mgroups[24m [Q]
                   [4mkwv-attr[24m    -> 'a=' [Q] [4mattr[24m [Q]
                   [4mkwv-expires[24m -> 'e=' [Q] [4mexpires[24m [Q]
                   [4mkwv-ip[24m      -> 'ip=' [Q] [4mip-addr[24m [Q]

                   [4muser[24m      -> [4msimple-name[24m | [4mDACS-identity[0m
                   [4mgroups[24m    -> [4mgroup[24m [',' [4mgroup[24m]*
                   [4mgroup[24m     -> [4mgroupname[24m | [4mrole-descriptor[0m
                   [4mattr[24m      -> [4many-alphabetic[0m
                   [4mip-addr[24m   -> [4many-IP-addr[0m
                   [4mexpires[24m   -> +[4mrel-secs[24m | [4mdate[0m

               where:

               +o   Q is an optional (matched) quote character;

               +o   whitespace may optionally precede most tokens;

               +o   a [4mDACS-identity[24m is a full or abbreviated [34m[1mDACS identity[0m[1m[22m[38]

               +o   a [4msimple-name[24m is the [4musername[24m component of a [1mDACS [22midentity
                   (i.e., without any colons); consequently in this context a
                   "special" name, such as auth, is treated as :auth

               +o   [4mrole-descriptor[24m must be a valid [1mDACS [22mrole string and
                   [4mgroupname[24m must be a valid [1mDACS [22mgroup name (see
                   [34m[1mdacs_authenticate(8)[0m[1m[22m[39] and [34m[1mdacs.groups(5)[0m[1m[22m[40]);

               +o   an IP address is expressed in the Internet standard numeric
                   dot notation (e.g., 10.0.0.1); and

               +o   the lifetime of credentials derived from the identity can
                   be expressed either as a given number of seconds (e.g,
                   "e=+3600") or a given date in one of the following formats
                   (see [34m[1mstrptime(3)[0m[1m[22m[41]):

                       %a, %d-%b-%Y %H:%M:%S GMT
                       %d-%b-%Y
                       %b %d, %Y
                       %b %d
                       %Y-%m-%dT%H:%M:%SZ

                   When necessary, dates are interpreted relative to the
                   current time or date. The lifetime is converted to its
                   canonical form, which is the absolute time and date in
                   seconds since the Epoch, based on the jurisdiction's clock.
                   A date in the past can be specified; this might be useful
                   for testing, for instance. If the identity is not used to
                   create credentials, the expiry date is ignored, although it
                   must be syntactically correct.

               +o   the only supported attribute value is "a", which means that
                   the identity should be treated as an [34m[1mADMIN_IDENTITY[0m[1m[22m[23]
                   (refer to the [1m-admin [22mflag of [34m[1mdacscheck(1)[0m[1m[22m[19]).

                   A name expressed in the concise syntax, gives a username
                   and, optionally, roles and attributes for the identity. It
                   is used by [34m[1mdacscheck(1)[0m[1m[22m[19], for instance.

   [1mThe dacs Utility[0m
       [1mDACS [22mutility commands are usually installed as separate binaries, but
       [1mDACS [22mcan (also or instead) be built with most of them combined into a
       single binary that is installed as [1mdacs[22m. The various utility programs
       may then be run as:

           % dacs [4mdacs-command[24m [[4mdacsoptions[24m] [[4mcommand-options[24m]

       For example:

           % dacs dacskey -u foo.myfed.com outfile

       Running the [1mdacs [22mutility without arguments will show the list of
       available sub-commands.

   [1mStart-up Processing[0m
       Most [1mDACS [22mprograms perform the following actions when they start:

        1. Process a standard set of command line arguments ([34m[4mdacsoptions[0m[4m[24m[42])

        2. Set the process umask to 007 to disallow world access for any
           created files

        3. Disable a core dump so that sensitive information cannot be
           revealed by examining them (but see [34m[1m--enable-dump[0m[1m[22m[43])

        4. Refuse to operate if any configuration file cannot be found or has
           an error

        5. For web services, make the [1mDACS [22mhome directory the current working
           directory

        6. If "secure mode" has been enabled, web services will only process
           HTTPS requests

        7. Verify that the version required by a request is compatible with
           the version of [1mDACS [22mreceiving the request

        8. Process any program-specific command line arguments.


       [1mDACS [22mprograms make an effort to destroy sensitive information (such as
       passwords) as soon as it is no longer needed and not to write
       potentially sensitive information to log files unless specifically
       configured to do so.

   [1mInternals[0m
       Some [1mDACS [22mcomponents may call other components using HTTP (possibly
       over SSL, depending on configuration). For example, authentication
       modules may be invoked as web services by [34m[1mdacs_authenticate(8)[0m[1m[22m[39]. In
       all cases, these "internal" HTTP calls may not result in a redirection,
       such as through a 302 Found status code. Although this can sometimes be
       an inconvenience, it is, in part, a security measure.

           [1mTip[0m
           When debugging a problem that may involve an internal HTTP request
           (especially related to authentication), verify that [1mDACS [22mis not
           receiving a redirect. Internal HTTP requests may also fail
           mysteriously because of incorrect or incomplete configuration of
           SSL parameters. Internal HTTP requests over SSL use
           [34m[1msslclient(1)[0m[1m[22m[4], as does the [34m[1mhttp(1)[0m[1m[22m[3] command. If you suspect
           that an https-schemed URL may not be working, debug the problem
           using [1msslclient [22mand then [1mhttp[22m.

       To maintain data consistency, [1mDACS [22mcreates exclusive locks using the
       [34m[1mfcntl(2)[0m[1m[22m[44] system call on files written in the directory configured
       through the [34m[1mTEMP_DIRECTORY[0m[1m[22m[45] directive.

   [1mLogging[0m
       Most [1mDACS [22mservices and utilities write various kinds of messages to one
       or more log files. These messages can be invaluable when trying to
       figure out what [1mDACS [22mis doing, for security audits, or to see which
       [1mDACS[22m-wrapped resources are being accessed and in what ways.

       Please refer to [34m[1mdacs.conf(5)[0m[1m[22m[46] for information about configuration
       directives related to logging. An assortment of command line flags,
       described below, are also related to logging.

           [1mNote[0m
           +o   [1mDACS [22mcan emit log messages before configuration processing is
               complete and configuration directives associated with logging
               are not in effect during this startup interval.

           +o   Because [34m[1mmod_auth_dacs[0m[1m[22m[2] is an [1mApache [22mmodule, the [1mApache[0m
               logging directives apply to it (and not the [1mDACS [22mdirectives)
               and its log messages are written to [1mApache [22mlog files.

           +o   Log files can quickly become large, especially when the logging
               level is set to debug or trace levels. Consider daily rotation
               or truncation.

           +o   The text of a log message may occasionally span several lines.

       The default value of the [34m[1mLOG_FORMAT[0m[1m[22m[47] directive, which controls the
       appearance of log messages, is defined in include/local.h as
       LOG_FORMAT_DEFAULT_WEB for [1mDACS [22mweb services and LOG_FORMAT_DEFAULT_CMD
       for everything else. Here is a typical log message:

           [Wed Jul 12 12:37:09 2006] [trace] [83648,1060,-] [dacs_acs:"acslib"] Allow
           clause grants access

       [1mAudit-Class Log Messages[0m
           In the case of audit-class messages, a string within parentheses
           may sometimes follow an identity, as in the examples below. This
           string, called a tracker, associates log messages with a particular
           origin and can be used to trace a user's sequence of service
           requests using log messages throughout a federation. This can be
           useful when debugging, looking for security problems, or forensic
           analysis.

           For an unauthenticated user, the tracker can only be derived
           heuristically, from elements of the execution context. The user's
           IP address, user agent string, and SSL client certificate, when
           available, are used. If two of these tracker strings differ, the
           requests are typically coming from different hosts, browsers, or
           users, but this is not necessarily always the case. Similarly, if
           the same tracker string is associated with two log messages, the
           service requests are not necessarily being issued by the same user.

           For an authenticated user, the tracker string consists of the
           heuristically-derived string, followed by a comma, followed by a
           string uniquely associated with the user's credentials. This
           tracker has a high probability of being unique and having a
           one-to-one mapping with a particular user.

           Consider these (condensed) log file entries:

               [Wed Jul 12 15:56:24 2006] [notice] [83963,1067,A] [dacs_acs:"authlib"]
                *** Access granted to unauthenticated user (7vJLWzv5) from 10.0.0.124
                for /cgi-bin/dacs/dacs_current_credentials

               [Wed Jul 12 15:56:27 2006] [notice] [83965,1073,A] [dacs_acs:"authlib"]
                *** Access granted to unauthenticated user (7vJLWzv5) from 10.0.0.124
                for /cgi-bin/dacs/dacs_authenticate

               [Wed Jul 12 15:56:27 2006] [debug] [83966,172,A] [dacs_authenticate:"authlib"]
                Authentication succeeded for HOME:bobo (7vJLWzv5,wA/Pudyp3f0)

               [Wed Jul 12 15:56:30 2006] [notice] [83973,1078,A] [dacs_acs:"authlib"]
                *** Access granted to DSS::HOME:bobo (7vJLWzv5,wA/Pudyp3f0)
                from 10.0.0.124 for /cgi-bin/dacs/dacs_current_credentials

           In the first two of the log messages above, the tracker 7vJLWzv5
           appears, meaning that the two requests probably came from the same
           (unauthenticated) user. With the third log message, the user has
           been authenticated and the tracker 7vJLWzv5,wA/Pudyp3f0 is used.
           Because these trackers all share the same prefix, the first two
           requests probably also came from someone who authenticated as
           DSS::HOME:bobo. The last request, for
           /cgi-bin/dacs/dacs_current_credentials, definitely came from that
           user. If this user were to signout and then issue more service
           requests anywhere in the federation DSS, each log message would
           contain the tracker 7vJLWzv5.

               [1mSecurity[0m
               Tracking the requests of anonymous users reliably is difficult
               to do well. A cookie-based approach may do better in some
               situations but has its own drawbacks (such as being totally
               ineffective when the user has disabled cookies).

   [1mTracking User Activity[0m
       [1mDACS [22mincludes a feature, enabled as a build-time option (see
       [34m[1mdacs.install(7)[0m[1m[22m[48]), whereby a jurisdiction can track the activity of
       all of its users (i.e., those users that authenticate at the
       jurisdiction). Each successful authentication event, explicit signout
       event, and user-submitted web service request event can be recorded at
       the user's home jurisdiction in the format defined by
       [34m[1mdacs_user_info.dtd[0m[1m[22m[49]. This information can be valuable for getting a
       better understanding of what is happening in a federation, including
       helping to diagnose performance and security issues. It is the basis of
       features like displays of recent account activity, and it might also be
       used to create new capabilities, such as a concurrent login limit or an
       adaptive authentication component to implement layered authentication
       or risk-based authentication.

       To specify where and how a home jurisdiction should maintain these
       records, the user_info item type must be defined at that jurisdiction;
       if it is not defined, no records will be written at that jurisdiction,
       although the jurisdiction will still try to send event records to other
       jurisdictions. For maximum benefit, the feature should be enabled at
       all jurisdictions in a federation since all user activity throughout
       the federation can then be logged.

       If a jurisdiction wants to monitor the activity of its users at other
       jurisdictions, it must allow those jurisdictions to invoke its
       [34m[1mdacs_vfs(8)[0m[1m[22m[50] service by adding an appropriate access control rule.

           [1mSecurity[0m
           It is critical for any such rule to require the [34m[1mdacs_admin()[0m[1m[22m[51]
           predicate.

           [1mNote[0m
           +o   The [34m[1mdacs_admin(8)[0m[1m[22m[52] tools provides an interface to these
               records. It should eventually be extended to collect and
               organize records found at all jurisdictions in a federation to
               facilitate analysis. Because they are text files with a
               relatively simple format, administrators should not find it
               difficult to apply common text processing tools or write short,
               custom programs for this purpose. Commands analogous to
               [34m[1mlast(1)[0m[1m[22m[53], [34m[1mwho(1)[0m[1m[22m[54], and [34m[1msa(8)[0m[1m[22m[55] are being considered.

           +o   Each jurisdiction should write records to its own place (i.e.,
               jurisdictions should not share the same VFS object for
               user_info).

           +o   This database will grow indefinitely; an administrator is
               responsible for rotating or truncating it. If previous and
               active sign on information is important (see
               [34m[1mdacs_current_credentials(8)[0m[1m[22m[56]), prune only the request
               records (i.e., the acs elements). Another acceptable method is
               to discard (or archive) some proportion of older records (say,
               half) and keep some of the newer records.

           +o   The data format is subject to change.

           +o   A directive to enable or disable this feature at run-time may
               be added.

           +o   Internal administrative events are not recorded.

           +o   Because logging off (via [34m[1mdacs_signout(8)[0m[1m[22m[57]) is optional, the
               end of a session can sometimes only be inferred or approximated
               from the expiry of credentials or the time of the last recorded
               event.


[1mOPTIONS[0m
       [1mDACS [22mprograms and web services get much of their run-time configuration
       information by reading configuration files and examining environment
       variables. Some configuration information can be provided at
       compile-time. Several command line flags may be used to override
       default behaviour.

           [1mNote[0m
           +o   All [4mdacsoptions[24m flags are processed left-to-right and must
               appear before any command-specific flag or argument. The first
               flag or argument that is not recognized as one of the
               [4mdacsoptions[24m terminates the list.

           +o   The most important [4mdacsoptions[24m are those that specify the
               location of configuration files and identify the jurisdiction
               section to use within a configuration file. Depending on the
               program and how it is used, configuration information may not
               be needed, may be optional, or may be required.

           +o   At most one of the command line flags to select a jurisdiction
               section can be specified. Refer to [34m[1mdacs.conf(5)[0m[1m[22m[46] for
               additional information on the configuration file and
               configuration processing.

       Many [1mDACS [22mutilities recognize the following standard options, which are
       called [4mdacsoptions[24m:

       [1m-c [4m[22mdacs.conf[0m
           This tells [1mDACS [22mwhere it can find a configuration file for the
           jurisdiction on whose behalf it is acting. If this argument is not
           present, depending on how it was built, [1mDACS [22mmay either try to use
           a compile-time specified file or it will try to use the value of
           the environment variable [34m[1mDACS_CONF[0m[1m[22m[58]. For details, refer to
           [34m[1mLocating dacs.conf and site.conf[0m[1m[22m[59].

       [1m-D[4m[22mname[24m[1m=[4m[22mvalue[0m
           The effect of this flag is to define variable [4mname[24m (which must be
           syntactically valid) in the [4mDACS[24m namespace to have the value [4mvalue[24m.
           Any quotes around [4mvalue[24m are retained, provided the shell has not
           already stripped them off. This flag may be repeated. These
           variables can subsequently be tested during configuration
           processing and rule processing; for example, the value of a
           configuration directive might depend on the value of a [4mdacsoptions[0m
           flag. Defining a [4mname[24m that happens to correspond to a [4mdacsoptions[0m
           flag has no effect other than to create the variable.

           All [4mdacsoptions[24m flags ([4mexcluding[24m [4mthis[24m [4mone[24m) are automatically added
           to the [4mDACS[24m namespace as they are processed. A flag that is a
           "singleton" (e.g., [1m-q[22m) is initially assigned a value of one and is
           incremented on each subsequent appearance. A flag of the form [4m-flag[0m
           [4mvalue[24m is equivalent to [1m-D[4m[22m-flag[24m[1m=[4m[22mvalue[24m. Unused flags are undefined;
           if [1m-q [22mis not given, [4m${DACS::-q}[24m will not be defined. For those
           flags that have synonyms, a variable for each synonym is created.
           If the [4mname[24m is used, explicitly or implicitly, later values replace
           earlier ones.

           For example, if the [4mdacsoptions[24m are:

               -c www.example.com -v --verbose -Dfoo="baz" -ll debug -D-ll=trace

           then variables will be defined as follows:

               ${DACS::-c} is "www.example.com"
               ${DACS::-v} is "2"
               ${DACS::--verbose} is "2"
               ${DACS::foo} is "\"baz\""
               ${DACS::-ll} is "trace"

           The debugging level will be debug and not trace.

       [1m--dumpenv[0m
           Print all environment variables to stdout and then exit
           immediately.

       [1m--enable-dump[0m
           By default, [1mDACS [22mweb services and most commands disable core dump
           generation as a security precaution. Because a core dump can be
           useful when debugging, this flag allows it to be created. As
           programs that are allowed to produce a core dump must change to the
           [4mDACS_HOME[24m directory, core dumps will be written there. Use this
           flag with care.

       [1m-format [4m[22mfmt[0m
           The output format is set to [4mfmt[24m, which is one of the following
           keywords (case insensitive): file, html, json, php, plain, text,
           xml, xmldtd, xmlsimple, or xmlschema. Not all output formats are
           supported by all programs. This flag overrides any [34m[1mFORMAT[0m[1m[22m[60]
           argument to a web service, which in turn overrides a program's
           default format. The default format depends on the particular
           program and way it is invoked. For additional information, refer to
           the [34m[1mdescription of the [4m[22mFORMAT[24m argument[0m[60].

       [1m-ll [4m[22mlogging-level[0m
           The logging level is set to [4mlog-level[24m, which is one of the keywords
           recognized by the [34m[1mLOG_FILTER[0m[1m[22m[61] directive.

       [1m--license[0m
           Print the license for [1mDACS [22mto stdout and then exit immediately.

       [1m-q[0m
           Be quiet. This is equivalent to setting the logging level to warn.

       [1m-sc [4m[22msite.conf[0m
           This tells [1mDACS [22mthat it can find a configuration file for the
           jurisdiction on whose behalf it is acting. If this argument is not
           present, depending on how it was built, [1mDACS [22mmay either try to use
           a compile-time specified file or it will try to use the value of
           the environment variable [34m[1mDACS_CONF[0m[1m[22m[58]. For details, refer to
           [34m[1mLocating dacs.conf and site.conf[0m[1m[22m[59].

       [1m--std[0m
           This flags the end of the common arguments. The next command line
           argument, if any, is specific to the program.

       [1m-t[0m
           Emit tracing information. This is equivalent to setting the logging
           level to trace. (Also see [34m[1mdebug_dacs[0m[1m[22m[62].)

       [1m-u [4m[22mconfig-uri[0m
           This instructs [1mDACS [22mto use [4mconfig-uri[24m to select the jurisdiction
           section to use in the configuration file. For details, refer to [34m[1mThe[0m
           [1m[34mJurisdiction Section[0m[1m[22m[63].

       [1m-uj [4m[22mjurisdiction-name[0m
           This instructs [1mDACS [22mto use the jurisdiction name [4mjurisdiction-name[0m
           to select the jurisdiction section to use in the configuration
           file. For details, refer to [34m[1mThe Jurisdiction Section[0m[1m[22m[63].

       [1m-un[0m
           This instructs [1mDACS [22mnot to process site.conf or dacs.conf. This may
           only be used with a small number of commands, such as
           [34m[1mdacsacl(1)[0m[1m[22m[64] and [34m[1msslclient(1)[0m[1m[22m[4].

       [1m-us[0m
           This instructs [1mDACS [22mto use the one-and-only jurisdiction section
           that appears in the configuration file. That is, the configuration
           file must contain exactly one jurisdiction section and that is the
           one that should be used. For details, refer to [34m[1mThe Jurisdiction[0m
           [1m[34mSection[0m[1m[22m[63].

       [1m-v[0m
       [1m--verbose[0m
           Be more verbose, relative to the current logging level. This flag
           may be repeated.

       [1m--version[0m
           Print version information to stderr immediately and then exit. If
           [1m-v [22mappeared earlier on the command line, also print version
           information for each [1mDACS [22msource code file in this program.

               [1mNote[0m
               Complete version information is available only for statically
               linked programs. Also see [34m[1mdacsversion(1)[0m[1m[22m[65] and
               [34m[1mdacs_version(8)[0m[1m[22m[66].

           [1mTip[0m
           If no command line flag is given to specify the jurisdiction
           section, the value of the environment variable [1mDEFAULT_JURISDICTION[0m
           will be used as if given with the [1m-uj [22mflag. This can be
           particularly useful when a host has only one jurisdiction
           configured because it makes it unnecessary to always specify the
           jurisdiction for [1mDACS [22mcommands.

[1mENVIRONMENT[0m
       [1mSERVER_NAME[22m, [1mSERVER_PORT[22m, [1mREQUEST_URI[0m
           May be used to determine the applicable jurisdiction.

[1mFILES[0m
       dacs.conf

       site.conf

[1mSEE ALSO[0m
       [34m[1mDACS manual pages[0m[1m[22m[67], [34m[1mdacs_admin(8)[0m[1m[22m[52], [34m[1mdacs.install(7)[0m[1m[22m[6],
       [34m[1mdacs.readme(7)[0m[1m[22m[5]

[1mBUGS[0m
       There should be some assistance for administering [34m[1muser activity[0m
       [1m[34mrecords[0m[1m[22m[68].

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[69])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[70] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. mod_auth_dacs
           http://dacs.dss.ca/man/mod_auth_dacs.html

        3. http(1)
           http://dacs.dss.ca/man/http.1.html

        4. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

        5. dacs.readme(7)
           http://dacs.dss.ca/man/dacs.readme.7.html

        6. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

        7. Denial of service attacks
           http://en.wikipedia.org/wiki/Denial-of-service_attack

        8. Cross-site scripting (XSS)
           http://en.wikipedia.org/wiki/Cross-site_scripting

        9. Cross-site request forgery (CSRF)
           http://en.wikipedia.org/wiki/Cross-site_request_forgery

       10. index page
           http://dacs.dss.ca/man/index.html

       11. RFC 2606
           http://www.rfc-editor.org/rfc/rfc2606.txt

       12. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

       13. BNF notation
           http://en.wikipedia.org/wiki/Backus%E2%80%93Naur_form

       14. Authorization Caching
           http://dacs.dss.ca/man/dacs_acs.8.html#authorization_caching

       15. Rlinks
           http://dacs.dss.ca/man/dacs_acs.8.html#rlinks

       16. capability-based system
           http://en.wikipedia.org/wiki/Capabilities

       17. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#credentials

       18. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       19. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

       20. execution environment
           http://www.freebsd.org/cgi/man.cgi?query=environ&apropos=0&sektion=7&manpath=FreeBSD+9.0-RELEASE&format=html

       21. current federation
           http://dacs.dss.ca/man/#current_federation

       22. current jurisdiction
           http://dacs.dss.ca/man/#current_jurisdiction

       23. ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#ADMIN_IDENTITY

       24. NAME_COMPARE
           http://dacs.dss.ca/man/dacs.conf.5.html#NAME_COMPARE

       25. user()
           http://dacs.dss.ca/man/dacs.exprs.5.html#user

       26. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       27. FEDERATION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_NAME

       28. FEDERATION_DOMAIN
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_DOMAIN

       29. JURISDICTION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#JURISDICTION_NAME

       30. DACS_IDENTITY
           http://dacs.dss.ca/man/dacs_acs.8.html#var_env_dacs_identity

       31. DACS_USERNAME
           http://dacs.dss.ca/man/dacs_acs.8.html#var_env_dacs_username

       32. RFC 2396
           http://www.rfc-editor.org/rfc/rfc2396.txt

       33. RFC 822
           http://www.rfc-editor.org/rfc/rfc822.txt

       34. RFC 3696
           http://www.rfc-editor.org/rfc/rfc3696.txt

       35. EXIT*
           http://dacs.dss.ca/man/dacs_authenticate.8.html#auth_directive_index

       36. setvar()
           http://dacs.dss.ca/man/dacs.exprs.5.html#setvar

       37. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html#roles

       38. DACS identity
           http://dacs.dss.ca/man/#dacs_identity

       39. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       40. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       41. strptime(3)
           http://www.freebsd.org/cgi/man.cgi?query=strptime&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       42. [4mdacsoptions[0m
           http://dacs.dss.ca/man/#dacsoptions

       43. --enable-dump
           http://dacs.dss.ca/man/#enable-dump-arg

       44. fcntl(2)
           http://www.freebsd.org/cgi/man.cgi?query=fcntl&apropos=0&sektion=2&manpath=FreeBSD+9.0-RELEASE&format=html

       45. TEMP_DIRECTORY
           http://dacs.dss.ca/man/dacs.conf.5.html#TEMP_DIRECTORY

       46. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       47. LOG_FORMAT
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_FORMAT

       48. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html#configure_options

       49. dacs_user_info.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_user_info.dtd

       50. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

       51. dacs_admin()
           http://dacs.dss.ca/man/dacs.exprs.5.html#DACS_ADMIN

       52. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       53. last(1)
           http://www.freebsd.org/cgi/man.cgi?query=last&apropos=0&sektion=1&manpath=FreeBSD+9.0-RELEASE&format=html

       54. who(1)
           http://www.freebsd.org/cgi/man.cgi?query=who&apropos=0&sektion=1&manpath=FreeBSD+9.0-RELEASE&format=html

       55. sa(8)
           http://www.freebsd.org/cgi/man.cgi?query=sa&apropos=0&sektion=8&manpath=FreeBSD+9.0-RELEASE&format=html

       56. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       57. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       58. DACS_CONF
           http://dacs.dss.ca/man/dacs_acs.8.html#var_env_dacs_conf

       59. Locating dacs.conf and site.conf
           http://dacs.dss.ca/man/dacs.conf.5.html#locating_dacs.conf

       60. FORMAT
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

       61. LOG_FILTER
           http://dacs.dss.ca/man/dacs.conf.5.html#logging_levels

       62. debug_dacs
           http://dacs.dss.ca/man/dacs_acs.8.html#debug_dacs

       63. The Jurisdiction Section
           http://dacs.dss.ca/man/dacs.conf.5.html#jurisdiction_section

       64. dacsacl(1)
           http://dacs.dss.ca/man/dacsacl.1.html

       65. dacsversion(1)
           http://dacs.dss.ca/man/dacsversion.1.html

       66. dacs_version(8)
           http://dacs.dss.ca/man/dacs_version.8.html

       67. DACS manual pages
           http://dacs.dss.ca/man/../man/index.html

       68. user activity records
           http://dacs.dss.ca/man/#tracking_user_activity

       69. www.dss.ca
           http://www.dss.ca

       70. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                           DACS(1)
