/*____________________________________________________________________________

        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        $Id: GTKFileSelector.cpp,v 1.9 2003/09/16 17:36:23 kgk Exp $
____________________________________________________________________________*/


#include <unistd.h>
#include <dirent.h>

#if defined(solaris)                                                          
#include <sys/types.h>                                                        
#include <sys/param.h>         /* for MAXPATHLEN */                           
#include <sys/stat.h>                                                         
#endif                                                                        

using namespace std;
#include "GTKFileSelector.h"
extern char old_path[PATH_MAX];


GTKFileSelector::GTKFileSelector(FAContext *context,const char *windowtitle)
{
    m_context = context;
    title = windowtitle;
    returnpath = "";
    extended = false;
    ok = false;
    done = false;
}

gboolean filesel_destroy(GtkWidget *widget, gpointer p)
{
    bool runmain = (bool)p;
    if (runmain)
        gtk_main_quit();
    return FALSE;
}

void ok_internal(GtkWidget *widget, GTKFileSelector *p)
{
    p->AddEvent();
}

void cancel_internal(GtkWidget *widget, GTKFileSelector *p)
{
    p->CancelEvent();
}

string GTKrecursive_path(char subdirs[PATH_MAX], string returnpath,int *sub_rnum)
{  
    DIR *dir=NULL;
    struct dirent *current=NULL;
#if defined(solaris)
    struct stat *s;
#endif
    if ((dir = opendir(subdirs))!=NULL){
        current = readdir(dir);
        current = readdir(dir); 
        while((current=readdir(dir))!=NULL){ 
#if defined(solaris)
	stat(subdirs, s);
	if (s->st_mode & S_IFDIR) {
#else
            if(current->d_type==DT_DIR){  
#endif
                char temp_subdir[PATH_MAX];
                strncpy(temp_subdir, subdirs,PATH_MAX);
                strcat(temp_subdir,"/");
                strncat(temp_subdir,current->d_name,FILENAME_MAX);
                returnpath = GTKrecursive_path(temp_subdir,returnpath,sub_rnum);
            }
            else {
                returnpath += "\n";
                returnpath += subdirs;
		returnpath += "/";
                returnpath += current->d_name;
                sub_rnum++;
            }
        }
    }
    closedir(dir);
    return (returnpath);
}                    

void GTKFileSelector::CancelEvent()
{
    gtk_widget_destroy(filesel);
    ok = false;
    done = true;
}

void GTKFileSelector::AddEvent()
{
    GtkFileSelection *gfile = GTK_FILE_SELECTION(filesel);
    char *raw_path = NULL;
    gchar **row=gtk_file_selection_get_selections(gfile);
    gint rownum = 0;
    gint sub_rnum = 0;
    char *temp, *path_temp;

    returnpath = gtk_file_selection_get_filename(gfile);
    path_temp = strdup(returnpath.c_str());

    char *tempdir = strrchr(path_temp, '/');
    if (!tempdir) {
        strcpy(path_temp, "/");
        path_temp = (char *)realloc(path_temp, strlen(path_temp) + 1);
    }
    else
        tempdir[0] = '\0';

    strncpy(old_path,path_temp,PATH_MAX);

    if (extended){
    returnpath="";
    
    if(row[rownum]){
	while (row[rownum]) {
	  returnpath += row[rownum];
	  returnpath += "\n";
	  rownum++;
	}
    }
    }
    g_strfreev(row);
    gtk_widget_destroy(GTK_WIDGET(gfile));
    free(path_temp);

    ok = true;
    done = true;
    m_context->prefs->SetPrefString(kLastDirPref, old_path);
}

bool GTKFileSelector::Run(bool runMain)
{
    bool dummyBool;
    int32_t dummyInt;
    if (!runMain)
        gdk_threads_enter();
    filesel = gtk_file_selection_new(title.c_str());
    m_context->prefs->GetPrefBoolean(kSetLastResumePref, &dummyBool);
    dummyInt = PATH_MAX;
    if(dummyBool){
	string old2_path;
	m_context->prefs->GetPrefString(kLastDirPref,&old2_path);
	strncpy(old_path,old2_path.c_str(),PATH_MAX);
	gtk_file_selection_set_filename (GTK_FILE_SELECTION (filesel), old_path);
    }
    else
	m_context->prefs->SetPrefString(kLastDirPref,"/");
    gtk_window_set_modal(GTK_WINDOW(filesel), TRUE);
    gtk_signal_connect(GTK_OBJECT(filesel), "destroy",
                       GTK_SIGNAL_FUNC(filesel_destroy), (gpointer)runMain);
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->cancel_button),
                       "clicked", GTK_SIGNAL_FUNC(cancel_internal), this);
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filesel)->ok_button),
                       "clicked", GTK_SIGNAL_FUNC(ok_internal), this);

    if (extended)
        gtk_clist_set_selection_mode(GTK_CLIST(GTK_FILE_SELECTION(filesel)->
                                     file_list), GTK_SELECTION_EXTENDED);
    gtk_widget_show(filesel);

    if (runMain)
        gtk_main();
    else {
        gdk_threads_leave();
        while (!done)
            usleep(20);
    }

    if (ok)
       return true;
    return false;
}

/* arch-tag: 558cc4b9-e74b-4d32-b37e-f9a905439c68
   (do not change this comment) */
