#ifndef _INCLUDED_MUSICLAYOUT_H_
#define _INCLUDED_MUSICLAYOUT_H_

#include <gtkmm/widget.h>
#include <gtkmm/box.h>
#include <gtkmm/paned.h>
#include <gtkmm/enums.h>
#include <assert.h>
#include "preferences.h"

class PanedLayout : public Gtk::HBox {
 public:
	PanedLayout();
 	~PanedLayout();
 
	//Set Widgets In Layout - Can Be NULL
 	void set_position(Gtk::Widget *Contents, unsigned int pos)
 		{ assert(pos < 4); m_positions[pos] = Contents; }
 
 	//Add Set Widgets To Layout
 	void create();
 
 private:
	//Internal Variables
	std::vector<Gtk::Paned *> m_panes;
 	Gtk::Widget *m_positions[4];
};

class MusicLayout : public Gtk::VBox {
 public:
	MusicLayout(Preferences *prefs);
 	~MusicLayout();
 
 	//Find Out What Widgets Are Needed, Dosn't Change Layout
 	void read_prefs();
 	//Add Needed Widgets To Layout, All Needed Widgets Must Have Been Set
 	void change_layout();
 
	//Return Widgets Needed
	bool need_library_tree() { return is_displayed(m_library_tree_pos); }
	bool need_album_list() { return is_displayed(m_album_list_pos); }
	bool need_track_list() { return is_displayed(m_track_list_pos); }
	//Always Needed, These Are Here In Case That Changes
 	bool need_playlist() { return true; } 
	bool need_menubar() { return true; }
	bool need_toolbar() { return true; }
	bool need_status_bar() { return true; } 
	
	//Set Widgets
	void set_library_tree(Gtk::Widget *new_tree) { m_library_tree = new_tree; }
	void set_album_list(Gtk::Widget *new_albumlist) { m_album_list = new_albumlist; }
	void set_track_list(Gtk::Widget *new_tracklist) { m_track_list = new_tracklist; }
	void set_playlist(Gtk::Widget *new_playlist) { m_playlist = new_playlist; }
	void set_menubar(Gtk::Widget *new_menu) { m_menu_bar = new_menu; }
	void set_toolbar(Gtk::Widget *new_toolbar) { m_toolbar = new_toolbar; }
	void set_status_bar(Gtk::Widget *new_statusbar) { m_status_bar = new_statusbar; }
	
	//TODO: Make Below Functions Store Changes In Preferences, Then do read_prefs()
	//Modify What Is Displayed
	bool get_library_displayed() { return m_show_library; }
	void set_library_displayed(bool library = true) { m_show_library = library; }
	
	Gtk::ToolbarStyle get_toolbar_style() { return m_toolbar_style; }
	void set_toolbar_style(Gtk::ToolbarStyle style) { m_toolbar_style = style; }
	
	int get_tab_position() { return m_tab_pos; }
	void set_tab_position(int new_pos) { m_tab_pos = new_pos; }
	
	//Set Widget Positions, first_level = -1 means off
	void set_playlist_pos(int first_level, int second_level = -1)
		{ m_playlist_pos[0] = first_level; m_playlist_pos[1] = second_level; }
	void set_library_tree_pos(int first_level, int second_level = -1)
		{ m_library_tree_pos[0] = first_level; m_library_tree_pos[1] = second_level; }
	void set_album_list_pos(int first_level, int second_level = -1)
		{ m_album_list_pos[0] = first_level; m_album_list_pos[1] = second_level; }
	void set_track_list_pos(int first_level, int second_level = -1)
		{ m_track_list_pos[0] = first_level; m_track_list_pos[1] = second_level; }
	
 private:
	//Internal Variables
	Preferences *m_prefs;
 	bool m_show_library;
 	
 	PanedLayout *m_actual_layout;
 	PanedLayout *m_second_layouts[4];
 
 	//Widget Details
 	int m_library_tree_pos[2];
 	Gtk::Widget *m_library_tree;
 
 	int m_album_list_pos[2];
 	Gtk::Widget *m_album_list;
 
 	int m_track_list_pos[2];
 	Gtk::Widget *m_track_list;
 
 	int m_playlist_pos[2];
 	Gtk::Widget *m_playlist;
 	int m_tab_pos; //Based On Gtk::PositionType - Plus -1 Means Off
 
 	Gtk::Widget *m_menu_bar;
 	Gtk::Widget *m_toolbar;
 	Gtk::ToolbarStyle m_toolbar_style;
 	Gtk::Widget *m_status_bar;
 
 	//Internal Functions
	inline bool is_displayed(int pos[]) { return (pos[0] != -1); }
	void add_item(Gtk::Widget *item, int item_pos[]);
	PanedLayout *get_second_level_layout(int first_level);
};
 
#endif
/* arch-tag: 61454df2-7401-4acd-a4d4-beff006f9fcb */
