/* -*- c++ -*-________________________________________________________________
 
        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        $Id: playsheet.h,v 1.2 2004/01/07 21:58:02 kgk Exp $
 ____________________________________________________________________________*/

#ifndef _PLAYSHEET_H
#define _PLAYSHEET_H 1

class Playsheet {
public:
    typedef std::vector<std::string> playlist_type;

    typedef playlist_type::value_type value_type;
    typedef playlist_type::size_type size_type;
    typedef playlist_type::iterator iterator;
    typedef playlist_type::const_iterator const_iterator;

public:  // vector interface
    iterator begin() { return m_urls.begin();}
    iterator end()   { return m_urls.end();}
    size_type size() { return m_urls.size(); }
    void clear() { m_urls.clear(); }
    void insert(iterator pos, const_iterator b, const_iterator e) {
        m_urls.insert(pos, b, e);
    }
    iterator insert(iterator b, const value_type&v){return m_urls.insert(b, v);}
    value_type& operator[](int x) {return m_urls.operator[](x);}
    void erase(iterator b, iterator e){m_urls.erase(b, e);}
    void erase(iterator b){m_urls.erase(b);}

public: //Extended interface

    Playsheet();
    Playsheet(const playlist_type&v);
    ~Playsheet();
    

    uint32_t find(const string&url);


    /** randomly shuffle the list */
    void shuffle();



private:
    playlist_type   m_urls;
    uint32_t        m_index;
};


#endif /* _PLAYSHEET_H */

// arch-tag: 95e50158-7a01-414a-bede-753037f35f94
