/*____________________________________________________________________________

        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

        $$
____________________________________________________________________________*/


#include <set>
#include <algorithm>
#include "cachedb.h"

using namespace std;


CacheDB::CacheDB()
    : MetadataDB(), m_map ()
{
}


CacheDB::~CacheDB()
{
}

// Force reloading of entire cache
void CacheDB::reload(MetadataDB*diskdb) 
{
#if 0
    MetadataDB::iterator urls = diskdb->begin();

    while (urls != diskdb->end()) {
        element_t pair = *urls;
        internalAdd(pair);
    }
#endif
}

void CacheDB::internalAdd(const element_t&pair)
{
    const url_t& url = pair.first;
    const Metadata& md = pair.second;

    m_map[url] = md;

}

bool
CacheDB::add(const url_t& url, const Metadata&md)
{
    pair<map_t::iterator, bool> r;
    r = m_map.insert(map_t::value_type(url, md));
    //(*r.first).second.SetDefaultPriority(m_priority);
    return true;
}

bool 
CacheDB::remove(const url_t&url)
{
    if (m_writesOK) 
        m_map.erase(url);
    return true;
}

bool 
CacheDB::contains(const url_t&url)
{
    map_t::iterator f = m_map.find(url);
    return f != m_map.end();
}

bool 
CacheDB::getMetadata(const string&url, Metadata&m)
{
    m = m_map[url];
    return true;
}

bool 
CacheDB::setMetadata(const string&url, const Metadata&m)
{
    //if (m_writesOK) 
    m_map[url] = m;
    return true;
}


Error 
CacheDB::query(const string&target, const params_t& params, result_t& results)
{
    // Special case for getting tracks listings.

    if (target == "tracks") {
        return queryTracks(params, results);
    }

    // Scan the entire array of items.
    //   Any item that matches the constraints
    //   then select the target tag from the 
    //   metadata and add it do the result set.
    set<string>  resultset;

    map_t::iterator p = m_map.begin();
    while (p!= m_map.end()) {
        Metadata& md = (*p).second;
        // All params must match selected values
        if (metadata_match(params, md)) {
            resultset.insert(md[target]);
        }
    }

    copy(resultset.begin(), resultset.end(), inserter(results, results.end()));

    return kError_NoErr;
}

Error CacheDB::queryTracks(const params_t& params, 
                           result_t& results)
{
    map_t::iterator p = m_map.begin();
    while (p!= m_map.end()) {
        Metadata& md = (*p).second;
        // All params must match selected values
        if (metadata_match(params, md)) {
            results.push_back((*p).first);
        }
    }
    return kError_NoErr;
}

bool 
CacheDB::metadata_match(const params_t& params, 
                        /*const */ Metadata& md)
{
    params_t::const_iterator p = params.begin();
    while (p != params.end()){
        if (md.hasKey(p->first)) {
            if (md[p->first] != p->second)
                return false;
        }
    }
    return true;
}


/* arch-tag: 628d2752-6f30-4073-b7d1-4524d1d140f5 */
