/*____________________________________________________________________________
   
   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)
   Portions Copyright (C) 1998-1999 EMusic.com

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   $Id: vorbislmc.h,v 1.6 2003/09/16 17:35:13 kgk Exp $

____________________________________________________________________________*/

#ifndef INCLUDED_VORBISLMC_H_
#define INCLUDED_VORBISLMC_H_

/* system headers */
#include <stdlib.h>
#include <time.h>
#include <vorbis/vorbisfile.h>
#include <string>
#include <vector>

/* project headers */
#include "config.h"

#include "pmi.h"
#include "pmo.h"
#include "mutex.h"
#include "event.h"
#include "lmc.h"
#include "thread.h"
#include "mutex.h"
#include "queue.h"
#include "semaphore.h"

class VorbisLMC : public LogicalMediaConverter
{

public:
            VorbisLMC(FAContext *context);
    virtual ~VorbisLMC();

    virtual uint32_t CalculateSongLength(const char *url);

    virtual Error ChangePosition(int32_t position);
    
    virtual Error CanDecode();
    virtual void  Clear();
    virtual Error ExtractMediaInfo();
    
    /** Gets the output buffer of this stream.  Because the output
     *  buffer will be prepared for the caller, this function should be
     *  called only once.
     *
     *  @param pBuffer is set to the output buffer. Normally it will be
     *  prepared for the caller.
     *
     *  @returns Returns an error if one happened.
     */
    virtual Error GetOutputBuffer(PullBuffer **pBuffer);
    
    virtual Error InitDecoder();
    
    virtual std::vector<std::string> *GetExtensions();
    
private:
    
    static int    SeekWrapper(void *stream, ogg_int64_t offset, int whence);
    static long   TellWrapper(void *stream);
    static int CloseWrapper(void *stream);
    static size_t ReadWrapper(void *buf, size_t size, size_t num, void*stream);
    int    Seek(long offset, int whence);
    long   Tell(void);
    size_t Read(void *buf, size_t size, size_t num);

    const std::string ConvertToISO(const char *utf8);

    static void          DecodeWorkerThreadFunc(void *);
    void                 DecodeWork();
    
    Thread              *m_decoderThread;
    
    const char          *m_szError; // marked for removal
    bool                 m_bInit;
    int                  m_channels, m_section, m_rate;
    long                 m_frameCounter, m_newPos;
    
    OggVorbis_File       m_vf;
};

#endif




/* arch-tag: d0a9c75c-10cf-47ec-a9f2-e38a1b84347f
   (do not change this comment) */
