/* $Id: GLView.cpp,v 1.22 2003/02/27 23:44:53 zongo Exp $
** 
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2003 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef WIN32
#include <windows.h>
#endif



#include <GL/glu.h>

#include <gtk/gtksignal.h>

#include <Modules/Renderer/GLRenderer.h>
#include <Ark/ArkCollision.h>
#include <Ark/ArkSystem.h>

#include "../Application.h"
#include "GLView.h"
#include <algorithm>

////////////////////////////////////////////////////////////////////////
// AREA ALLOCATION.
// ENSURE THAT THE SAME CACHE IS SHARED BY ALL THE GL WIDGETS
////////////////////////////////////////////////////////////////////////

GLView::GtkGLAreaList GLView::s_Areas;
  
Ark::GLCache GLView::s_GLCache;

// =========================================================================

Ark::Vector3 
GLView::GetGLPos(int mx, int my) const
{
  /* Sure, this is quite a tricky way to retrieve world pos
   * from mouse pos, but hey! it works :) */

  double projmat[16];
  double modelmat[16];
  double x, y, z;
  int viewport[4];
  float zbuf;

  int w = GTK_WIDGET(m_Area)->allocation.width;
  int h = GTK_WIDGET(m_Area)->allocation.height;

  if (mx < 0 || my < 0 || mx > w || my > h)
    return Ark::Vector3();

  /* Invert y, because of OGL coord system */
  my = h - my;

  glGetIntegerv(GL_VIEWPORT, viewport);
  glGetDoublev(GL_PROJECTION_MATRIX, projmat);
  glGetDoublev(GL_MODELVIEW_MATRIX, modelmat);

  /* Get position infos from OpenGL */
  glReadPixels(mx, my, 1, 1, GL_DEPTH_COMPONENT, GL_FLOAT, &zbuf);
  gluUnProject(mx, my, zbuf, modelmat, projmat, viewport, &x, &y, &z);

  return Ark::Vector3((float)x, (float)y, (float)z);
}

// =========================================================================

GLView::GLView() : 
  ViewWidget()
{
   AllocArea();
   gtk_object_set_data( GTK_OBJECT(m_Area), "Viewptr", this);
}

GLView::~GLView ()
{
  // Unrefs the renderer
  if (m_Renderer)
    m_Renderer->Unref();

  // Removes the GLarea from the list
  s_Areas.erase( std::remove(s_Areas.begin(), s_Areas.end(), m_Area), s_Areas.end());

  // If the list is empty, clears the common cache
  if (s_Areas.empty())
  {
    s_GLCache.Clear(true);
  }

}

GLView*
GLView::GetView(GtkWidget *widget)
{
  return (GLView*) gtk_object_get_data(GTK_OBJECT(widget), "Viewptr");
}

bool
GLView::Render()
{
  if (!gtk_gl_area_make_current(m_Area))
     return true;

  const int w = GTK_WIDGET(m_Area)->allocation.width;
  const int h = GTK_WIDGET(m_Area)->allocation.height;

  m_Renderer->SetViewport(0, 0, w, h);
  glClear(GL_DEPTH_BUFFER_BIT|GL_COLOR_BUFFER_BIT);

  return true;
}


static int
ClampCoord(int x, int max)
{
  if (x > max)
    return max;
  else if (x < 0)
    return 0;
  else return x;
}


bool
GLView::Motion(int x, int y, int state)
{
  
  m_Width = GTK_WIDGET(m_Area)->allocation.width;
  m_Height = GTK_WIDGET(m_Area)->allocation.height;

  x = ClampCoord(x, m_Width - 1);
  y = ClampCoord(y, m_Height - 1);
  
  bool ret = Motion(x, y, state, m_LX, m_LY);

  if (ret) 
  {
    m_LX = x;
    m_LY = y;
  }

  return ret;
}


bool
GLView::Expose()
{
   if (!gtk_gl_area_make_current(m_Area))
      return true;

   AllocRenderer();
   Render();
   gtk_gl_area_swapbuffers(m_Area);

   return true;
}

bool
GLView::Redraw()
{
  GdkRectangle area = { 
    0, 
    0,
    GTK_WIDGET(m_Area)->allocation.width,
    GTK_WIDGET(m_Area)->allocation.height 
  };

  gtk_widget_draw(GTK_WIDGET(m_Area), &area);
  return true;
}

void 
GLView::AllocArea()
{
   static int params[] = { 
      GDK_GL_RGBA,
      GDK_GL_DOUBLEBUFFER,
      GDK_GL_DEPTH_SIZE, 16,
      GDK_GL_NONE
   };
   
   if (s_Areas.empty())
      m_Area = GTK_GL_AREA( gtk_gl_area_new(params) );
   else
      m_Area = GTK_GL_AREA( gtk_gl_area_share_new(params, s_Areas[0]) );
   
   s_Areas.push_back(m_Area);
}

void 
GLView::AllocRenderer()
{
   if (m_Renderer)
      return; 
   
   m_Renderer = new Ark::GLRenderer(&s_GLCache);
   
   if (s_GLCache.GetColSystem() == NULL)
   {
      //FIXME: should do that only for the main window. this is ugly :)
      s_GLCache.SetColSystem(Ark::ColSystemFactory::CreateColSystem
			     ("ark::Collision"));
      g_Application->SetView(this);
   }
}
