#ifndef WE_WORLDBACKEND_H
#define WE_WORLDBACKEND_H

#include "World.h"

class ViewWidget;

class WorldHelper
{
      World* m_World;

   public:
      WorldHelper ();
      virtual ~WorldHelper();
      
      // World operations
      void NewWorld(const std::string& path,
		    const std::string& name, int w, int h);
      void Load(const std::string& path);
      void Write() const;


      // Wrapper functions around the World member
      bool CanSave() const;
      bool IsChanged() const;

      // Wrapper functions around the World member
      const std::string& GetFileName() const;
      void SetFileName(const std::string& path);

      virtual World* GetWorld();

      // Called whenever the view widget is changed.
      void SetView (ViewWidget* view);
};


#endif
