// $Id: HeightFieldChange.cpp,v 1.4 2001/10/13 20:17:45 zongo_fr Exp $

#include <string.h>

#include "HeightFieldChange.h"


HeightFieldChange::~HeightFieldChange()
{
  // Delete undo information
  if (m_State)
  {
    delete[] m_State;
  }
  
}


void
HeightFieldChange::Update()
{
  // Remove undo information
  if (m_State)
  {
    delete[] m_State;
  }
  
  // Reset it
  m_State = 0;
}


void 
HeightFieldChange::InitState(short value)
{
    if (m_State) return;

    const Ark::HeightField* hf = m_World;
    const unsigned int size = hf->m_SizeX * hf->m_SizeZ;

    assert( size || "Size of height field is zero !" );

    m_State = new short[size];

    short* ptr = m_State;
    
    // Sets everything to the default value
    for  (unsigned int i=0 ; i<size ; ++i, ++ptr)
	*ptr = value;

}


