// $Id: HFEOffset.h,v 1.3 2001/10/28 23:24:43 nekeme Exp $
#ifndef WE_HFE_OFFSET_H
#define WE_HFE_OFFSET_H

#include <stdlib.h>
#include <math.h>
#include <time.h>

#include "HFEditHeight.h"


class HFEOffset : public HFEditHeight
{
  public:
    HFEOffset(World* w, int type, int size, float att, float str) 
      : HFEditHeight(w, type, size, att, str)
    {
    }


  protected:
    virtual void ApplyAtPoint(int x, int z, float factor);
    virtual int ComputeOffset(int before, float factor) = 0;
    
    inline float ComputeOffsetAttenuation(float factor) {
	return m_Strength * ComputeStandardAttenuation(factor) / m_World->m_ScaleY;
    }
    
    /// Create a command with a correct state.
    virtual Command* CreateCommand();

};

// ========================================================================
// ========================================================================
// ========================================================================

static 
void InitRand()
{
   static bool inited = false;

   if (inited)
      return;

   srand( time(NULL) );
   inited = true;
}

class HFENoise : public HFEOffset
{
  public:
    HFENoise(World* w, int type, int size, float att, float str) 
      : HFEOffset(w, type, size, att, str)
    {
      InitRand();
    }

    virtual HFEditHeight* CreateNew(World* w, int t,int s, float a, float h) const;

  protected:
    virtual int ComputeOffset(int before, float factor);
};

// ========================================================================
// ========================================================================
// ========================================================================

class HFEHigher : public HFEOffset
{
  public:
    HFEHigher(World* w, int type, int size, float att, float str) 
      : HFEOffset(w, type, size, att, str)
      {
      }


    virtual HFEditHeight* CreateNew(World* w, int t,int s, float a, float h) const;

  protected:
    virtual int ComputeOffset(int before, float factor);
};

// ========================================================================
// ========================================================================
// ========================================================================

class HFELower : public HFEOffset
{
  public:
    HFELower(World* w, int type, int size, float att, float str) 
      : HFEOffset(w, type, size, att, str)
      {
      }

    virtual HFEditHeight* CreateNew(World* w, int t,int s, float a, float h) const;

  protected:
    virtual int ComputeOffset(int before, float factor);
};

#endif // WE_HFE_OFFSET_H
