<?php
// Copyright 2003,2004 by Won-Kyu Park <wkpark at kldp.org>
// All rights reserved. Distributable under GPL see COPYING
// a octave processor plugin for the MoniWiki
//
// Usage: {{{#!octave
// code..
// }}}
// $Id: octave.php,v 1.1 2004/08/02 11:24:55 wkpark Exp $

function processor_octave($formatter="",$value="") {
  global $DBInfo;

  if(getenv("OS")=="Windows_NT")
    $octave="woctave"; # Win32
  else
    #$octave="octave -q -H --no-init-file --no-line-editing -f ";
    $octave="octave -q -H -f ";

  $vartmp_dir=$DBInfo->vartmp_dir;
  $cache_dir=$DBInfo->upload_dir."/Octave";

  if ($value[0]=='#' and $value[1]=='!')
    list($line,$value)=explode("\n",$value,2);

  $plt=$value;

# a sample for testing
#  $plt='
#set term gif
#!  ls
#plot sin(x)
#';

  # normalize plt
  $plt="\n".$plt."\n";
  $plt=preg_replace("/\s*;\s*\n/",";\n",$plt);
  $plt=preg_replace("/\n\s*![^\n]+\n/","\n",$plt); # strip shell commands
  $plt=preg_replace("/[ ]+/"," ",$plt);
  $plt=preg_replace("/\ngset?\s+(t|o|si).*\n/", "\n",$plt);
  
  #print "<pre>$plt</pre>";

  $uniq=md5($plt);

  $outpath="$cache_dir/$uniq.png";

  $src="
gset size 0.5,0.6
gset term png
gset output '$outpath'
$plt
";

  if (!file_exists($cache_dir)) {
    umask(000);
    mkdir($cache_dir,0777);
    umask(022);
  }

  if ($formatter->refresh || !file_exists("$cache_dir/$uniq.png")) {

     $flog=tempnam($vartmp_dir,"OCTAVE");
     #
     # for Win32 woctave.exe
     #
     if(getenv("OS")=="Windows_NT") {
       $finp=tempnam($vartmp_dir,"OCTAVE");
       $ifp=fopen($finp,"w");
       fwrite($ifp,$src);
       fclose($ifp);

       $cmd= "$octave < $finp > $flog";
       $fp=system($cmd);
       $log=join(file($flog),"");
       unlink($flog);
       unlink($finp);
     } else {
       #
       # Unix
       #
       $cmd= "$octave 2> $flog";
       $fp=popen($cmd,"w");
       fwrite($fp,$src);
       pclose($fp);
       $log=implode('',file($flog));
       #if ($log) unlink($outpath);
       unlink($flog);
     }

     if ($log)
        $log ="<pre style='background-color:black;color:gold'>$log</pre>\n";
  }
  return $log."<img src='$DBInfo->url_prefix/$cache_dir/$uniq.png' alt='octave' />";
}

// vim:et:sts=2:
?>
