<?php
// Copyright 2004 Won-Kyu Park <wkpark at kldp.org>
// All rights reserved. Distributable under GPL see COPYING
// a Jmol plugin for the MoniWiki
//
// http://jmol.sf.net
//
// $Id: chat.php,v 1.3 2003/06/13 13:30:54 wkpark Exp $

function processor_jmol($formatter,$value="") {
    if ($value[0]=='#' and $value[1]=='!')
      list($line,$value)=explode("\n",$value,2);

    $body = $value;
    $args='<param name="emulate" value="chime" />';
    $args.='<param name="progressbar" value="true" />';

    while ($body and $body[0] == '#') {
        # extract first line
        list($line, $body) = explode("\n",$body, 2);

        # skip comments (lines with two hash marks)
        if ($line[1] == '#') continue;

        # parse the PI
        list($verb, $args) = explode(' ',$line,2);
        $verb = strtolower($verb);
        $args = rtrim($args);

        if (in_array(array('#sticks','#ball&stick','#wireframe','#spacefill'),$verb))
            $args.='<param name="style" value="'.$verb.'" />';
    }

    if (!$args)
        $args.='<param name="style" value="sticks" />';

    $buff=str_replace("\n","|\n",$body)."\n";
    $molstring= trim($buff);

    $pubpath = $formatter->url_prefix.'/applets/JmolPlugin';

    return <<<APP
<applet code='JmolApplet.class' height='200' width='200' archive='$pubpath/JmolApplet.jar' codebase='$pubpath'>
        $args
        <param name='inline' value='$molstring' />
    Loading a JmolApplet object.
</applet>
APP;
}

// vim:et:sts=4:sw=4:
?>
