import errno
import os
import xml

import gtk

import BaseWindow
import FolderTree
import Filesel
import Alert
import MetaData
import Storage

def open_alert(primary, secondary):
    Alert.Alert(gtk.STOCK_DIALOG_ERROR, [(gtk.STOCK_OK,)], primary, secondary)

def open_document(app_model, window, filename):
    assert type(filename) == type(u"")
    primary = u"Could not open document \"%s\"." % filename
    
    filename = os.path.abspath(filename)
    if os.path.isfile(filename):
    	if os.path.basename(filename) == u"lodju.xml":
	    filename = os.path.dirname(filename)
	else:
	    secondary = u"It is not a Lodju file."
	    open_alert(primary, secondary)
	    return

    if os.path.isdir(filename):
    	st = Storage.Storage(filename)
	data = st.read_file(u"lodju.xml")
	if data == u"":
	    secondary = u"It does not contain a valid Lodju index file."
	    open_alert(primary, secondary)
	    return
	try:
	    p = MetaData.Parser()
	    p.feed(data)
	    doc = p.close()
	except xml.sax.SAXParseException:
	    open_alert(primary,
		       u"The contents of the index file were not in the " +
		       u"format expected by Lodju. The file may be " +
		       u"corrupt or perhaps you selected a file not " +
		       u"created by Lodju.")
	else:
	    doc[u"filename"] = unicode(filename)
	    doc.storage.discard()
	    doc.storage = st
	    if window:
	    	window.set_document(doc)
	    else:
		# Need to create an application window, not BaseWindow.
		# Can't import Window at top level before BaseWindow.py has
		# been evaluated. Circular dependencies suck.
		View(app_model, doc)
	    doc.clear_dirty()

	return

    secondary = u"It is neither a file, nor a directory."
    open_alert(primary, secondary)


class View(BaseWindow.View):

    def __init__(self, app_model, doc):
    	model = BaseWindow.Model(doc)
    	BaseWindow.View.__init__(self, 
				 model, 
				 Controller(model, self),
				 FolderTree.View(self, model.doc,
				    	         app_model.trash, 
						 model.xml), 
				 app_model)
    	self.show()


class Controller(BaseWindow.Controller):

    def on_open_activate(self, *args):
	Filesel.Filesel(u"Open file", self.filesel_location, 
	    	    	gtk.FALSE, gtk.FALSE, self.open_ok)

    def open_ok(self, filenames):
    	assert len(filenames) == 1
	filename = unicode(filenames[0])
	self.set_filesel_location(filename)
	if self.model.doc.is_empty():
	    open_document(self.view.app_model, self.view, filename)
	else:
	    open_document(self.view.app_model, None, filename)
