import gtk
import MetaDataEditor


class View:

    def __init__(self, dummy, title):
	self.title = title
    	self.controller = Controller(self)
    	self.widget = None
	self.editor = None

    def show(self, attrlist, metadata):
	self.widget = gtk.Dialog()
	self.widget.set_default_size(300, 300)
	self.widget.set_title(self.title)
	self.widget.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
	self.widget.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
	self.widget.connect("response", self.controller.response)
	
    	table = gtk.Table()
	self.editor = MetaDataEditor.View(table, self.controller.ok)
    	self.editor.setup(attrlist, [metadata])

    	scrolled = gtk.ScrolledWindow()
	scrolled.add_with_viewport(table)
	scrolled.set_policy(gtk.POLICY_NEVER, gtk.POLICY_ALWAYS)
	self.widget.vbox.pack_start(scrolled, gtk.TRUE, gtk.TRUE)

    	self.widget.show_all()

    def hide(self):
    	self.widget.destroy()


class Controller:

    def __init__(self, view):
    	self.view = view

    def ok(self):
    	self.view.hide()

    def response(self, *args):
	id = args[1]
	if id in [gtk.RESPONSE_OK, 
	    	  gtk.RESPONSE_CLOSE, 
		  gtk.RESPONSE_DELETE_EVENT]:
	    self.view.hide()
	elif id == gtk.RESPONSE_CANCEL:
	    self.view.hide()
	    if self.view.editor:
		self.view.editor.controller.restore()
    	else:
	    # Unknown response, shouldn't be possible.
	    print "other", id
	    self.view.hide()
