/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _DTREELISTITEMBASE_H
#define _DTREELISTITEMBASE_H

#include <klistview.h>
#include "../gui/DGuiItem.h"
#include "../datastruct/DItem.h"

class DDataItem;
class DTreeListView;
class QDropEvent;
/**
 * Mindmap item view
 *
 * @short Mindmap item view
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DTreeListItem : public KListViewItem, public DGuiItem
{
    public:
	DTreeListItem(DTreeListView*, int id);
	virtual ~DTreeListItem();	

	virtual void update();

	virtual int compare(QListViewItem*, int, bool) const;

	void paintCell( QPainter * p, const QColorGroup & cg, 
		int column, int width, int align );

	QString tipText();

//	void dropped(QDropEvent * e);
//	bool acceptDrop( const QMimeSource * ) const;
};


#endif // _DTREELISTITEMBASE_H

