// TYPEDEF.H : some typedefs + other settings here...

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef TYPEDEF_H
#define TYPEDEF_H

/*################################################################################################*/

/* added by Robert Williams for Compaq cxx, alpha 11/28/01 */
#define __USE_STD_IOSTREAM

#include <iostream>
using namespace std;

/*################################################################################################*/

/**	A template class for fixed-size arrays of three units.
	
	STL seems to be unable to store/handle the classical fixed-size arrays, 
	since there is no way to define the operators...
*/

template <class TYPE1> class a3
{
	public:
	
	TYPE1 data[3];
	
	public:
	
	a3(void) { }
	
	a3(const TYPE1 * p1)
	{
		for (int n1 = 0;n1 < 3;n1++) data[n1] = p1[n1];
	}
	
	a3(TYPE1 p1, TYPE1 p2, TYPE1 p3)
	{
		data[0] = p1;
		data[1] = p2;
		data[2] = p3;
	}
	
	~a3(void) { }
	
	TYPE1 & operator[](int p1) const
	{
		return (TYPE1 &) data[p1];
	}
	
	friend ostream & operator<<(ostream & p1, const a3<TYPE1> & p2)
	{
		p1 << "x = " << p2.data[0] << ", y = " << p2.data[1] << ", z = " << p2.data[2];
		return p1;
	}
};

/*################################################################################################*/

typedef int i32s;
typedef unsigned int i32u;

typedef double f64;

typedef double f64_a3[3];	// a classical fixed-size array...
typedef double f64_a4[4];	// a classical fixed-size array...

typedef a3<double> a3_f64;	// a fixed-size array for STL...

/*################################################################################################*/

// currently we need GLUT in all graphics, because we use it to print some bitmap characters...
// it would be possible to make separate text output functions for TARGET2/TARGET3, but why bother???

#ifndef TARGET1
#include <GL/glut.h>	// include GL stuff in TARGET2 and TARGET3!

typedef GLint iGLs;
typedef GLuint iGLu;

typedef GLfloat fGL;

typedef GLfloat fGL_a3[3];	// a classical fixed-size array...
typedef GLfloat fGL_a4[4];	// a classical fixed-size array...

typedef a3<GLfloat> a3_fGL;	// a fixed-size array for STL...

#else			// in TARGET1 just define basic types...

typedef int iGLs;
typedef unsigned int iGLu;

typedef float fGL;

typedef float fGL_a3[3];	// a classical fixed-size array...
typedef float fGL_a4[4];	// a classical fixed-size array...

typedef a3<float> a3_fGL;	// a fixed-size array for STL...

#endif

/*################################################################################################*/

typedef fGL ValueFunction(fGL *, void *, fGL *);
typedef void ColorFunction(fGL, fGL, fGL *);

/*################################################################################################*/

#endif	// TYPEDEF_H

// eof
