// QM1ALG.H : algorithms for qm1-models.

// Copyright (C) 2001 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef QM1ALG_H
#define QM1ALG_H

class qm1_geomopt;
class qm1_geomopt_param;

/*################################################################################################*/

#include "qm1eng.h"
#include "conjgrad.h"

/*################################################################################################*/

/// A geometry optimization class for QM models.

class qm1_geomopt : public conjugate_gradient
{
	protected:
	
	qm1_eng * eng;
	f64 * tss_target;
	
	public:
	
	qm1_geomopt(qm1_eng *, i32s, f64, f64 * = NULL);
	~qm1_geomopt(void);
	
	f64 GetValue(void);		// virtual
	f64 GetGradient(void);		// virtual
	
	static void AddConst(i32s, qm1_eng *, f64 *);
};

class qm1_geomopt_param
{
//	protected:
	public:		// in TARGET3 we have to access this from a function -> gets complicated. fix later...
	
	bool confirm;
	
	friend class qm1_mdl;
	friend class glut_qm1_docv;
	
	public:
	
	bool enable_nsteps;
	i32s treshold_nsteps;
	
	bool enable_grad;
	f64  treshold_grad;
	
	bool enable_delta_e;
	f64  treshold_delta_e;
	
	public:
	
	qm1_geomopt_param(void) { confirm = false; }
	~qm1_geomopt_param(void) { }
};

/*################################################################################################*/

/// A transition state search class...

class qm1_simple_ts_search
{
	protected:
	
	qm1_mdl * mdl;
	
	f64 * target[2];
	f64 energy[2];
	
	public:
	
	qm1_simple_ts_search(qm1_mdl *);
	~qm1_simple_ts_search(void);
	
	void UpdateTargets(void);
	void Run(i32s);
	
	protected:
	
	void SetTarget(i32s, i32s);
};

/*################################################################################################*/

#endif	// QM1ALG_H

// eof
