// INTCRD.CPP

// Copyright (C) 2001 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "intcrd.h"

#include "define.h"
#include "v3d.h"

#include <iostream>
using namespace std;

/*################################################################################################*/

ic_data::ic_data(void)
{
	previous = NULL;
	cartesian = NULL;
	
	is_variable = false;
}

ic_data::~ic_data(void)
{
}

/*################################################################################################*/

intcrd::intcrd(void)
{
	basecrd[0][0] = 1.0; basecrd[0][1] = 0.0; basecrd[0][2] = 0.0;
	basecrd[1][0] = 1.0; basecrd[1][1] = 1.0; basecrd[1][2] = 0.0;
	basecrd[2][0] = 1.0; basecrd[2][1] = 1.0; basecrd[2][2] = 1.0;
	
	base[0].cartesian = basecrd[0]; base[0].previous = NULL;
	base[1].cartesian = basecrd[1]; base[1].previous = & base[0];
	base[2].cartesian = basecrd[2]; base[2].previous = & base[1]; base[2].torv = 0.0;
}

intcrd::~intcrd(void)
{
	for (i32u n1 = 0;n1 < ic_vector.size();n1++)
	{
		delete ic_vector[n1];
	}
}

void intcrd::AddNewPoint(fGL * newcrd, ic_data * prev, bool is_variable)
{
//cout << "add BEGIN - ";
/////////////////////////////////////
/////////////////////////////////////
	ic_data * newic = new ic_data();
	
	newic->cartesian = newcrd;
	newic->previous = prev;
	
	ic_data * prev2 = prev->previous;
	ic_data * prev3 = prev2->previous;
	
	v3d<fGL> v1(prev->cartesian, newcrd);
	newic->len = v1.len();
	
	v3d<fGL> v2(prev->cartesian, prev2->cartesian);
	newic->ang = v1.ang(v2);
	
	v3d<fGL> v3(prev2->cartesian, prev3->cartesian);
	newic->torc = v1.tor(v2, v3); newic->torv = 0.0;
	
	newic->is_variable = is_variable;
	if (is_variable) variable_index_vector.push_back(ic_vector.size());
	
	ic_vector.push_back(newic);
/////////////////////////////////////
/////////////////////////////////////
//cout << "add END" << endl;
}

void intcrd::UpdateCartesian(void)
{
	for (i32u n1 = 0;n1 < ic_vector.size();n1++)
	{
		ic_data * curr = ic_vector[n1];
		ic_data * prev = curr->previous;
		ic_data * prev2 = prev->previous;
		ic_data * prev3 = prev2->previous;
		
		fGL tor = curr->torc + prev->torv;
		v3d<fGL> tmpvA(prev2->cartesian, prev3->cartesian);
		
		v3d<fGL> v1(prev->cartesian, prev2->cartesian);
		
		v3d<fGL> tmpvB = v1 * (v1.spr(tmpvA) / (v1.len() * v1.len()));
		v3d<fGL> v2 = tmpvA - tmpvB;
		
		v3d<fGL> v3 = tmpvA.vpr(v1);
		
		v1 = v1 * (curr->len * cos(curr->ang)) / v1.len();
		v2 = v2 * (curr->len * sin(curr->ang) * cos(tor)) / v2.len();
		v3 = v3 * (curr->len * sin(curr->ang) * sin(tor)) / v3.len();
		
		v3d<fGL> tmpvC = ((v1 + v2) + v3);
		
		for (i32s n2 = 0;n2 < 3;n2++)
		{
			curr->cartesian[n2] = prev->cartesian[n2] + tmpvC[n2];
		}
	}
}

i32s intcrd::GetVariableCount(void)
{
	return variable_index_vector.size();
}

i32s intcrd::FindVariable(fGL * c1, fGL * c2)
{
	i32s index2 = FindTorsion(c1, c2);
	if (index2 < 0) return NOT_DEFINED;
	
	// now try to find the torsion from variable vector...
	// now try to find the torsion from variable vector...
	// now try to find the torsion from variable vector...
	
	for (i32u index1 = 0;index1 < variable_index_vector.size();index1++)
	{
		if (variable_index_vector[index1] == (i32u) index2) return index1;
	}
	
	return NOT_DEFINED;
}

void intcrd::SetVariable(i32s index1, fGL value)
{
	i32u index2 = variable_index_vector[index1];
	ic_vector[index2]->torv = value;
}

fGL intcrd::GetVariable(i32s index1)
{
	i32u index2 = variable_index_vector[index1];
	return ic_vector[index2]->torv;
}

i32s intcrd::GetTorsionCount(void)
{
	return ic_vector.size();
}

i32s intcrd::FindTorsion(fGL * c1, fGL * c2)
{
	i32u n1 = 0;
	while (n1 < ic_vector.size())
	{
		if (ic_vector[n1]->cartesian == c1 && ic_vector[n1]->previous->cartesian == c2) return n1;
		if (ic_vector[n1]->cartesian == c2 && ic_vector[n1]->previous->cartesian == c1) return n1;
		
		n1++;
	}
	
	return NOT_DEFINED;
}

void intcrd::SetTorsion(i32s index, fGL value)
{
	ic_vector[index]->torv = value;
}

fGL intcrd::GetTorsion(i32s index)
{
	return ic_vector[index]->torv;
}

/*################################################################################################*/

// eof
