/* C Mode */

/* libframerd.c
   Implements init function for the FramerD library, including
   both ODB and index functions.
   Originally implemented by Ken Haase in the Machine Understanding Group
     at the MIT Media Laboratory.

   Copyright (C) 1994-2001 Massachusetts Institute of Technology
   Copyright (C) 2001-2002 beingmeta, inc. (A Delaware Corporation)

   This program comes with absolutely NO WARRANTY, including implied
   warranties of merchantability or fitness for any particular purpose.

    Use, modification, and redistribution of this program is permitted
    under the terms of either (at the developer's discretion) the GNU
    General Public License (GPL) Version 2, the GNU Lesser General Public
    License.

    This program is based on the FramerD library released in Fall 2001 by
    MIT under both the GPL and the LGPL licenses, both of which accompany
    this distribution.  Subsequent modifications by beingmeta, inc. are
    also released under both the GPL and LGPL licenses (at the developer's
    discretion).
*/ 

static char vcid[] =
  "$Id: libframerd.c,v 1.4 2002/04/02 21:39:34 haase Exp $";

#include "framerd.h"

static int framerd_initialized=0;

DTYPES_EXPORT void fd_initialize_dtypes(void);
extern void fd_initialize_pools_c(void);
extern void fd_initialize_file_pool_c(void);
extern void fd_initialize_network_pool_c(void);
extern void fd_initialize_super_pool_c(void);
extern void fd_initialize_odb_c(void);
extern void fd_initialize_frames_c(void);
extern void fd_initialize_index_c(void);
extern void fd_initialize_file_index_c(void);
extern void fd_initialize_network_index_c(void);
extern void fd_initialize_search_c(void);

FRAMERD_EXPORT
/* fd_report_framerd_stats:
    Arguments: none
    Returns: void
   Reports framerd stats to the standard error.
*/
void fd_report_framerd_stats(FILE *to)
{
  if (to == NULL) to=stderr;
  fprintf(to,
	  _(";; %d pools, %d indices, %d net connections\n"),
	  fd_get_pool_count(),fd_get_index_count(),fd_get_server_count());
#if (FD_LIGHTWEIGHT_OIDS)
  fprintf(to,
	  _(";; %d OIDs currently loaded, %d new OIDs, %d OID loads overall, %d symbols\n"),
	  fd_loaded_oids,
	  fd_new_oids,fd_oids_loaded,
	  fd_symbol_table()->n_keys);
#else
  fprintf(to,
	  _(";; %d/%d OIDs refd/loaded, %d new OIDs, %d OID loads, %d symbols\n"),
	  fd_oid_table()->n_keys,fd_loaded_oids,
	  fd_new_oids,fd_oids_loaded,
	  fd_symbol_table()->n_keys);
#endif
  fprintf(to,_(";; %ld+%ld=%ld bytes currently in use total\n"),
	  fd_cons_usage(),fd_malloc_usage(),fd_cons_usage()+fd_malloc_usage());
  fflush(to);
}


FRAMERD_EXPORT void fd_initialize_framerd()
{
  if (framerd_initialized) return; else framerd_initialized=1;
  fd_initialize_dtypes();
  fd_initialize_pools_c();
  fd_initialize_file_pool_c();
  fd_initialize_network_pool_c();
  fd_initialize_super_pool_c();
  fd_initialize_odb_c();
  fd_initialize_frames_c();
  fd_initialize_index_c();
  fd_initialize_file_index_c();
  fd_initialize_network_index_c();
  fd_initialize_search_c();
}

#if ((defined(WIN32)) && (!(defined(STATICLINK))))
BOOL APIENTRY DllMain( HANDLE hModule, 
                        DWORD ul_reason_for_call, 
                        LPVOID lpReserved )
{
    switch( ul_reason_for_call ) {
    case DLL_PROCESS_ATTACH:
      fd_initialize_framerd(); break;
    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
    case DLL_PROCESS_DETACH:
      {}
    }
    return TRUE;
}
#endif




/* File specific stuff */

/* The CVS log for this file
   $Log: libframerd.c,v $
   Revision 1.4  2002/04/02 21:39:34  haase
   Added log and emacs init entries to C source files

*/

/* Emacs local variables
;;;  Local variables: ***
;;;  compile-command: "cd ../..; make" ***
;;;  End: ***
*/
