/*
  Copyright (c) 1994-2001 by the Massachusetts Institute of Technology.
  Copyright (c) 2001-2002 by beingmeta, inc. (A Delaware Corporation)
  All rights reserved.

  $Id: fdwww.h,v 1.6 2002/05/27 13:00:46 haase Exp $

  This file is part of FramerD, a representation language and semantic
  database developed by Kenneth B. Haase and his students at the Media
  Laboratory at the Massachusetts Institute of Technology in Cambridge,
  Massachusetts.  Research at the Media Lab is supported by funds and
  equipment from a variety of corporations and government sponsors whose
  contributions are gratefully acknowledged.

    Use, modification, and redistribution of this program is permitted
    under the terms of either (at the developer's discretion) the GNU
    General Public License (GPL) Version 2, the GNU Lesser General Public
    License.

    This program is based on the FramerD library released in Fall 2001 by
    MIT under both the GPL and the LGPL licenses, both of which accompany
    this distribution.  Subsequent modifications by beingmeta, inc. are
    also released under both the GPL and LGPL licenses (at the developer's
    discretion).

  This is the file fdwww.h supporting html generation code by providing
   an HTTP stream abstraction.

*************************************************************************/

#if ((WITH_FASTCGI) && (HAVE_FCGIAPP_H) && (HAVE_LIBFCGI))
#define HAVE_FASTCGI 1
#else
#define HAVE_FASTCGI 0
#endif

#if (!(defined(HTMLGEN_EXPORT)))
#define HTMLGEN_EXPORT extern
#endif

#if (HAVE_FASTCGI)
#include <fcgiapp.h>
#endif

typedef struct FD_HTTP_STREAM {
  enum {stdio, fcgi, sstream} stream_type;
  int is_xml;
  union {
    FILE *fileptr;
    struct FD_STRING_STREAM *sstream;
#if (HAVE_FASTCGI)
    FCGX_Stream *fcgi;
#endif
  } stream;
} fd_htstream;

enum display_level {get_value, show_value, hide_value};
enum http_generation_phase {
  http_any=0, http_head, html_start, html_head, html_body, html_frameset,
  html_end };

HTMLGEN_EXPORT void fd_unparse_xml(fd_lisp,fd_lispenv,fd_htstream *);

HTMLGEN_EXPORT void fd_start_http_output(fd_htstream *s);
HTMLGEN_EXPORT void fd_set_http_output_methods
  (void (*_puts)(char *,void *),void (*_putc)(int,void *),
   void (*_putn)(char *,int,void *));
HTMLGEN_EXPORT void fd_http_puts(char *,fd_htstream *);
HTMLGEN_EXPORT void fd_http_write_bytes(char *,int,fd_htstream *);

/* XML functions */
EXPORTED fd_exception fd_XML_Parse_Error, fd_XML_Mismatch;
EXPORTED fd_lisp fd_make_xmltag(fd_lisp ns,fd_lisp base);
EXPORTED fd_lisp fd_xmltag_name(fd_lisp tag);
EXPORTED fd_lisp fd_xmltag_namespace(fd_lisp tag);
EXPORTED fd_lisp fd_xml_tag(fd_lisp x);
EXPORTED fd_lisp fd_xml_attributes(fd_lisp x);
EXPORTED fd_lisp fd_xml_content(fd_lisp x);
EXPORTED fd_lisp fd_parse_xml(fd_u8char *string,int err_level,fd_lisp ns);
EXPORTED fd_lisp fd_parse_html(fd_u8char *string);

#define FD_XMLTAGP(x) ((FD_SYMBOLP(x)) || (FD_LRECORD_TYPEP(tag,xmltag_tag)))

  




/* File specific stuff */

/* The CVS log for this file
   $Log: fdwww.h,v $
   Revision 1.6  2002/05/27 13:00:46  haase
   Added external API for http output from C

   Revision 1.5  2002/04/02 21:41:08  haase
   Added log and emacs init entries to C source files

*/

/* Emacs local variables
;;;  Local variables: ***
;;;  compile-command: "cd ../..; make" ***
;;;  End: ***
*/
