/* crafted.h
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


typedef struct player_t
{
  gchar   side;
  gchar   owner;
  gchar   ai;
  gushort gold;
  gushort wood;
  gushort oil;
} player_t;

typedef struct tPud
{
  gchar    *path;
  gboolean  is_loaded;
  gboolean  readonly;
  gboolean  modified;
  gint      version, sub_version;
  gchar    *description;
  gint      terrain;
  gint      width, height;
  gushort  *fields;
  GList    *units;
  player_t  player[16];
} tPud;

extern tPud Pud;

extern GtkWidget *drawing_area;
extern gint x_offset, y_offset;
extern GdkPixmap *tileset_pixmap;

extern guint verbosity;
extern GtkWidget *hscroll, *vscroll;

void after_load(void);
void progressbar_init(void);
void progressbar_update(gdouble percentage, gchar *text);
void progressbar_finish(void);

