/*
 *  Author:       Serg Stoyan
 *
 *  Classes:      AppController : NSObject
 *
 *  Description:  Application's Controller. Action regarding application
 *                icon, application icon window, application menu.
 *                Manages creation/deletion windows and panels, access
 *                to application defaults (preferences).
 */

#import <Foundation/NSObject.h>
#import <AppKit/NSApplication.h>

@class AppIcon;
@class AppDefaults;
@class SessionWindow;
@class InfoPanel;
@class SessionPrefsPanel;

#define ConnectApp [NSApp delegate]

@interface AppController : NSObject
{
  AppIcon           *appIcon;
  AppDefaults       *appDefaults;
  InfoPanel         *infoPanel;
  SessionWindow     *sessionWindow;
  SessionPrefsPanel *sessionPrefsPanel;
}

- (void) applicationWillFinishLaunching: (NSNotification *)notify;

- (void) applicationDidFinishLaunching: (NSNotification *)notify;

- (void) createMenu;

- (AppIcon *) appIcon;

- (AppDefaults *) appDefaults;

- (SessionWindow *) sessionWindow;

- (SessionPrefsPanel *) sessionPrefsPanel;

- (void) showInfoPanel: (id)sender;

- (void) showPrefPanel: (id)sender;

- (void) configureSession: (id)sender;

- (void) infoPanelWillClose;

- (void) sessionPrefsPanelWillClose;

@end

@interface NSApplication (Forward)

- (void) forwardInvocation: (NSInvocation *)anInvocation;

@end

