/* 
    main_menubar.h
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _MAIN_MENUBAR_H_
#define _MAIN_MENUBAR_H_

typedef struct _FileSubMenu FileSubMenu;
typedef struct _EditSubMenu EditSubMenu;
typedef struct _ViewSubMenu ViewSubMenu;
typedef struct _ProjectSubMenu ProjectSubMenu;
typedef struct _FormatSubMenu FormatSubMenu;
typedef struct _BuildSubMenu BuildSubMenu;
typedef struct _BookmarkSubMenu BookmarkSubMenu;
typedef struct _DebugSubMenu DebugSubMenu;
typedef struct _CVSSubMenu CVSSubMenu;
typedef struct _SettingsSubMenu SettingsSubMenu;
typedef struct _MainMenuBar MainMenuBar;

struct _FileSubMenu
{
	GtkWidget *new_file;
	GtkWidget *open_file;
	GtkWidget *save_file;
	GtkWidget *save_as_file;
	GtkWidget *save_all_file;
	GtkWidget *close_file;
	GtkWidget *close_all_file;
	GtkWidget *reload_file;
	GtkWidget *new_project;
	GtkWidget *import_project;
	GtkWidget *open_project;
	GtkWidget *save_project;
	GtkWidget *close_project;
	GtkWidget *rename;
	GtkWidget *print;
	GtkWidget *print_preview;
	GtkWidget *recent_files;
	GtkWidget *recent_projects;
	GtkWidget *exit;
};

struct _EditSubMenu
{
	GtkWidget *undo;
	GtkWidget *redo;
	GtkWidget *cut;
	GtkWidget *copy;
	GtkWidget *paste;
	GtkWidget *clear;
	
	GtkWidget *uppercase;
	GtkWidget *lowercase;
	GtkWidget *convert_crlf;
	GtkWidget *convert_lf;
	GtkWidget *convert_cr;
	GtkWidget *convert_auto;

	GtkWidget *insert_header;
	GtkWidget *insert_custom_indent;
	GtkWidget *insert_c_switch;
	GtkWidget *insert_c_for;
	GtkWidget *insert_c_while;
	GtkWidget *insert_c_ifelse;
	
	GtkWidget *insert_cvs_author;
	GtkWidget *insert_cvs_date;
	GtkWidget *insert_cvs_header;
	GtkWidget *insert_cvs_id;
	GtkWidget *insert_cvs_log;
	GtkWidget *insert_cvs_name;
	GtkWidget *insert_cvs_revision;
	GtkWidget *insert_cvs_source;
	
	GtkWidget *insert_c_gpl;
	GtkWidget *insert_cpp_gpl;
	GtkWidget *insert_py_gpl;
	GtkWidget *insert_username;
	GtkWidget *insert_datetime;
	GtkWidget *insert_header_template;
	GtkWidget *insert_changelog_entry;

	GtkWidget *select_all;
	GtkWidget *select_brace;
	GtkWidget *select_block;
	GtkWidget *select_function;
	GtkWidget *select_line;
	GtkWidget *select_word;
	
	GtkWidget *autocomplete;
	GtkWidget *calltip;

	GtkWidget *find;
	GtkWidget *find_next;	
	GtkWidget *find_previous;
	GtkWidget *find_in_files;
	GtkWidget *find_replace;
	GtkWidget *enter_selection;

	GtkWidget *comment_block;
	GtkWidget *comment_box;
	GtkWidget *comment_stream;

	GtkWidget *goto_line;
	GtkWidget *goto_brace;
	GtkWidget *goto_block_start;
	GtkWidget *goto_block_end;
	GtkWidget *goto_prev_mesg;
	GtkWidget *goto_next_mesg;
	GtkWidget *go_back;
	GtkWidget *go_forward;
	GtkWidget *goto_tag_def;
	GtkWidget *goto_tag_decl;
};

struct _ViewSubMenu
{
	GtkWidget *main_toolbar;
	GtkWidget *extended_toolbar;
	GtkWidget *browser_toolbar;
	GtkWidget *debug_toolbar;
	GtkWidget *format_toolbar;

	GtkWidget *editor_linenos;
	GtkWidget *editor_markers;
	GtkWidget *editor_folds;
	GtkWidget *editor_indentguides;
	GtkWidget *editor_whitespaces;
	GtkWidget *editor_eolchars;
	GtkWidget *editor_linewrap;

	GtkWidget *messages;
	GtkWidget *project_listing;
	GtkWidget *bookmarks;
	GtkWidget *breakpoints;
	GtkWidget *registers;
	GtkWidget *shared_lib;
	GtkWidget *signals;
	GtkWidget *dump_window;
};

struct _ProjectSubMenu
{
	GtkWidget *add_file;
	GtkWidget *view_file;
	GtkWidget *edit_file;
	GtkWidget *remove_file;
	GtkWidget *configure;
	GtkWidget *project_info;
	GtkWidget *dock_undock;
	GtkWidget *update_tags;
	GtkWidget *rebuild_tags;
	GtkWidget *edit_app_gui;
	GtkWidget *project_help;
};

struct _FormatSubMenu
{
	GtkWidget *indent;
	GtkWidget *indent_inc;
	GtkWidget *indent_dcr;
	GtkWidget *force_hilite;
	GtkWidget *open_folds;
	GtkWidget *close_folds;
	GtkWidget *toggle_fold;
	GtkWidget *detach;
};

struct _BuildSubMenu
{
	GtkWidget *compile;
	GtkWidget *make;
	GtkWidget *build;
	GtkWidget *build_all;
	GtkWidget *save_build_messages;
	GtkWidget *install;
	GtkWidget *autogen;
	GtkWidget *configure;
	GtkWidget *build_dist;
	GtkWidget *clean;
	GtkWidget *clean_all;
	GtkWidget *stop_build;
	GtkWidget *execute;
	GtkWidget *execute_params;
};

struct _BookmarkSubMenu
{
	GtkWidget *toggle;
	GtkWidget *first;
	GtkWidget *prev;
	GtkWidget *next;
	GtkWidget *last;
	GtkWidget *clear;
};

struct _DebugSubMenu
{
	GtkWidget *start_debug;
	GtkWidget *open_exec;
	GtkWidget *load_core;
	GtkWidget *attach;
	GtkWidget *restart;
	GtkWidget *stop_prog;
	GtkWidget *detach;
	GtkWidget *interrupt;
	GtkWidget *send_signal;
	GtkWidget *cont;
	GtkWidget *step_in;
	GtkWidget *step_out;
	GtkWidget *step_over;
	GtkWidget *run_to_cursor;
	GtkWidget *tog_break;
	GtkWidget *set_break;
	GtkWidget *show_breakpoints;
	GtkWidget *disable_all_breakpoints;
	GtkWidget *clear_all_breakpoints;
	GtkWidget *add_watch;
	GtkWidget *inspect;
	GtkWidget *stop;

	GtkWidget *info_targets;
	GtkWidget *info_program;
	GtkWidget *info_udot;
	GtkWidget *info_threads;
	GtkWidget *info_variables;
	GtkWidget *info_locals;
	GtkWidget *info_frame;
	GtkWidget *info_args;
	GtkWidget *info_memory;
};

struct _CVSSubMenu
{
	GtkWidget* update_file;
	GtkWidget* commit_file;
	GtkWidget* add_file;
	GtkWidget* remove_file;
	GtkWidget* status_file;
	GtkWidget* log_file;
	GtkWidget* diff_file;
	GtkWidget* update_project;
	GtkWidget* commit_project;
	GtkWidget* import_project;
	GtkWidget* status_project;
	GtkWidget* log_project;
	GtkWidget* diff_project;
	GtkWidget* login;
};

struct _SettingsSubMenu
{
	GtkWidget *compiler;
	GtkWidget *src_paths;
	GtkWidget *commands;
	GtkWidget *preferences;
	GtkWidget *style_editor;
	GtkWidget *file_view_filters;
	GtkWidget *user_properties;
	GtkWidget *default_preferences;
	GtkWidget *shortcuts;
};

/* Help menu should not be touched as it
is often modifed by gnome when the help
TOC (table of contents) is not found, resulting a screw-up */
/*
struct _HelpSubMenu
{
	GtkWidget *gnome;
	GtkWidget *man;
	GtkWidget *info;
	GtkWidget *context_help;
	GtkWidget *search;
	GtkWidget *about;
};
*/
struct _MainMenuBar
{
	FileSubMenu file;
	EditSubMenu edit;
	ViewSubMenu view;
	ProjectSubMenu project;
	FormatSubMenu format;
	BuildSubMenu build;
	BookmarkSubMenu bookmark;
	DebugSubMenu debug;
	CVSSubMenu cvs;
	SettingsSubMenu settings;
	/* HelpSubMenu help; */
};

void create_main_menubar (GtkWidget * app, MainMenuBar * mb);

GtkWidget *create_submenu (gchar * title, GList * strings,
			   GtkSignalFunc callback_func);

void main_menu_install_hints (GtkWidget* gnome_app);

#endif
