//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_WINDOW_H
#define GUI_WINDOW_H

//--------------------
//forward declarations
class QGridLayout;
class QPixmap;
class TitleWidget;
class LayoutWidget;
class StatusWidget;
//class SlideshowWidget;
class Configuration;
//--------------------

#include <qwidget.h>

//=====================================
/*! \brief Top level widget, encapsulates the title widget, the layout
 *  widget, and the toolbar widget.
 */
//=====================================
class Window : public QWidget
{
Q_OBJECT
//----------------------
public:
  ///Creates title area, layout, and tool bar and places them in grid.
  Window( QWidget *parent=0, const char* name=0);

  ///Save user settings on destruct
  ~Window();

  ///returns a pointer to the title widget
  TitleWidget* getTitle();

  ///returns a pointer to the layout object
  LayoutWidget* getLayout();

  ///returns a pointer to the status widget
  StatusWidget* getStatus();

  ///refreshes the layout
  void refresh();

  ///get setting object
  Configuration* getConfig();
      
  //-3-3-3-3-3-3-3-3-3-3-3-3-3-3-3-3-3
  //the following pixmaps REALLY need to be placed in an icon container class. other label icons could be placed
  //in such a class to speed up drawing and lower memory usage potentally

  //shadow pixmaps
  QPixmap *shadowBL, *shadowB, *shadowBR, *shadowR, *shadowTR;

  //info pixmap
  QPixmap *photoInfo;
  //-3-3-3-3-3-3-3-3-3-3-3-3-3-3-3-3-3
//----------------------
  /*
public slots:
  ///starts a slideshow to start at the beginning of the album
  void startSlideshowAtBeginning();
  
  ///starts a slideshow at currently selected photo
  void startSlideshowWithSelectedPhoto();
//----------------------
private slots:  
  ///start a slideshow
  void endSlideshow();
   */
//----------------------
protected:
  //reimplementation of event handler
  bool event( QEvent * );
  
  //window hidden
  void hideEvent( QHideEvent *);

  //window restored
  void showEvent( QShowEvent *);

  //window closed, quit app and save settings
  void closeEvent( QCloseEvent* e);
  //----------------------
private:
  ///utility function used by above, actually started slideshow
  void startSlideshow(bool startAtBeginning);
     
  ///Configuration settings
  Configuration* config;

  ///Grid objects placed in
  QGridLayout* grid;

  ///Title widget cont  ains menu's, album information and Album Shaper icon
  TitleWidget* title;

  ///Layout includes subalbums listing and particular subalbum layout
  LayoutWidget* layout;

  ///Status widget either displays a status message or progress bar
  StatusWidget* status;
  
  ///Slideshow widget handles in program slideshow presentations
//  SlideshowWidget* slideshow;
//----------------------
};
//======================

#endif //GUI_WINDOW_H
