//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_SUBALBUMSWIDGET_H
#define GUI_SUBALBUMSWIDGET_H

//forward declarations
class QIconViewItem;
class QToolButton;
class LayoutWidget;
class SubalbumsIconView;
class Subalbum;
class SubalbumPreviewWidget;

#include <qwidget.h>

//=====================================
/*! \brief Columnview of all subalbums in album.
 */
//=====================================

class SubalbumsWidget : public QWidget
{
Q_OBJECT

public:
  ///Creates layout
  SubalbumsWidget(QWidget *parent=0, const char* name=0);

  ///Refreshes list of collections, selecting first by default
  void refreshCollectionsList();

  ///Returns parent
  LayoutWidget* getParent();

  ///Activates/Deactives create/delete buttons
  void updateButtons(bool enable);

  ///Returns current selection
  QIconViewItem* getCurrentSelection();

  ///Returns the currently selected subalbum
  Subalbum* getSelectedSubalbum();    

  ///Select specified subalbum
//  void setSelectedSubalbum( Subalbum* selection );
//----------------------
private:
  ///select first collection
  void selectFirstCollection();
  
  ///select specified collection
  void selectCollection( QIconViewItem* item );

  ///list of subalbums
  SubalbumsIconView* collections;
  
  //Currently selected item
  QIconViewItem* currentSelection;
  
  ///Create collection button
  QToolButton* createButton;
  
  ///Delete collection button
  QToolButton* deleteButton;
  
  ///Pointer to layoutwidget this widget is in
  LayoutWidget* layout;
  
  ///Cached enabled/disabled state of buttons
  bool buttonsState;
  //----------------------
signals:
    void collectionSelected( Subalbum* );
//----------------------
public slots:
  void updatedSelectedCollectionImage( QPixmap* val);
  void refreshSelectedCollectionName();
//----------------------
private slots:
  ///create a new collection
  void createAction();

  ///deletes the currently selected collection
  void deleteAction();

  ///respond to user clicking collection icons
  void handleSelectionAttempt( QIconViewItem* item);
  
  ///relayout collectionicons after a create/delete refresh
  void reorder();
//----------------------
};
//======================

#endif //GUI_SUBALBUMSWIDGET_H
