//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qnamespace.h>
#include <qkeysequence.h>

//Projectwide includes
#include "annotating.h"
#include "helpWindow.h"
#include "../../config.h"

//==============================================
QString Annotating::filename()
{
  return QString("%1/annotating.html").arg(TEMP_DIR);
}
//==============================================
void Annotating::generateHTML(QTextStream::Encoding type, QString charSet)
{
  //create/open html file
  QFile file( filename() );
  if(file.open(IO_WriteOnly))
  {
    //-----
    QTextStream stream;
    stream.setEncoding( type );
    stream.setDevice( &file );
    //-----
    stream << "<html><head>\n";
    stream << "<meta http-equiv='Content-Type' content='text/html; charset=" << charSet << "'>\n";
    stream << "</head><body>\n";
    stream << "<table cellpadding='4'><tr>\n";
    stream << "<td><img src='" << IMAGE_PATH << "helpImages/asHelpLogoSmall.png'></td>\n";
    stream << "<td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << HelpWindow::tr("Annotating Albums") << "</font></td>\n";
    stream << "</tr></table>\n";
    
    stream << "<font face='Arial, sans-serif'>\n";
    stream << "<table cellspacing='10' cellpadding='0'><tr><td>\n";
    //------------------------------------------------------------------    
    stream << "  <table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "  <font size='+1'><b>" << HelpWindow::tr("Labeling Photos:") <<"</b></font>\n";
    stream << "  </td></tr></table>\n";

    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "  <p align='justify'>\n";
    stream << HelpWindow::tr("Labeling photos is easy in Album Shaper! Hover over a picture and click the little info button that appears in the lower right corner. The photo will expand to give you a better view and provide space for writing the caption. When you're done, click elsewhere in the collection, or just hit Escape. Alternatively, you can just use the keyboard. The arrow keys will move the current selection. Enter expands the currently selected photo to edit its caption. Escape applies the photo caption and returns to organizing.");
    
    stream << "</td><td valign='middle'>\n";
    stream << "  <img src='" << IMAGE_PATH << "helpImages/settingPhotoDescription.png'>\n";
    stream << "</td></tr></table>\n";

    stream << "    <p align='justify'>\n";
    stream << HelpWindow::tr("Album Shaper provides a number of tools that operate on multiple photos at once. If you want to remove a number of photos descriptions at once, select which photos you intend to affect, and select <font color='red'>Photos &rarr; Remove Description</font>.");
    
    //------------------------------------------------------------------    
    stream << "</td></tr><tr><td>\n";
    //------------------------------------------------------------------    

    stream << "      <table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "      <font size='+1'><b>" << HelpWindow::tr("Album and Collection Information:") << "</b></font>\n";
    
    stream << "      </td></tr></table>\n";
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "      <img src='" << IMAGE_PATH << "helpImages/albumInfo.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "      <p align='justify'>\n";
    
    stream << HelpWindow::tr("At the top left your album's name, description, and author can be specified.");
    
    stream << "</td></tr></table>\n";
    
    //------------------------------------------------------------------    
    stream << "</td></tr><tr><td>\n";
    //------------------------------------------------------------------    

    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "      <p align='justify'>\n";
    stream << HelpWindow::tr("To modify a collection's information, first select the collection within the collections listing on the left, then fill in its name and description at the top right.");
    stream << "</td><td valign='middle'>\n";
    stream << "      <img src='" << IMAGE_PATH << "helpImages/collectionInfo.png'>\n";
    stream << "</td></tr></table>\n";
    
    //------------------------------------------------------------------    
    stream << "</td></tr><tr><td>\n";
    //------------------------------------------------------------------    
    stream << "      <table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "      <font size='+1'><b>" << HelpWindow::tr("Cover Images:") << "</b></font>\n";
    stream << "      </td></tr></table>\n";

    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "      <img src='" << IMAGE_PATH << "helpImages/setRepImage.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "  <p align='justify'>\n";

    stream << HelpWindow::tr("It is easier to distinguish between albums and collections using images rather than text, and Album Shaper allows you to do that by setting album and collection cover images.");
    
    stream << "<p align='justify'>\n";
    
    stream << HelpWindow::tr("To use a photo to represent your album, drag and drop it to the left of the album name, description, and author fields. A small version of the photo should slide in from the left, and will be used when creating web galleries in the future.");

    stream << "<p align='justify'>\n";

    stream << HelpWindow::tr("A collection's cover image can be set in a similar fashion by dragging and dropping a photo to the left of the collection name and description  fields. One can accomplish either of these tasks by right clicking on a photo.");
    
    stream << "</td></tr></table>\n";
    //------------------------------------------------------------------    
    stream << "</td></tr><tr><td>\n";
    //------------------------------------------------------------------    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "  <p align='justify'>\n";
    stream << HelpWindow::tr("You can replace cover images in the future by dropping a new photo on top of the original cover image. A cover image can be removed by hovering over and clicking the red button that appears.") << "\n";
    stream << "</td><td valign='middle'>\n";
    stream << "  <img src='" << IMAGE_PATH << "helpImages/removeCollectionImage.png'>\n";
    stream << "</td></tr>\n";
    //-----------------------
    stream << "</table></font>\n";
    stream << "</body></html>\n";
    file.close();
  }
}
//==============================================
