<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:variable name="themeVersion">Radiant v1.0, Christian Sandberg</xsl:variable>
<xsl:variable name="pageHeader">
This album was generated by Album Shaper, download it here:
http://albumshaper.sourceforge.net

The theme was created by Christian Sandberg.
http://www.d-play.com
</xsl:variable>

<xsl:output method="html" indent="yes"/>

<xsl:include href="utils.xsl"/>

<xsl:template match="album">

<xsl:variable name="albumAuthor" select="author"/>
<xsl:variable name="albumName" select="name"/>
<xsl:variable name="Myear" select="substring-before(modified, ' ')"/>
<xsl:variable name="Mmonth" select="substring-before( substring-after(modified, ' '), ' ')"/>
<xsl:variable name="Mday" select="substring-after( substring-after(modified, ' '), ' ')"/>






<!-- ####################### THIS IS THE HEADER IN ESCAPED FORMAT ################## -->
<xsl:variable name="header">
&lt;div style="text-align:center"&gt;
&lt;table cellspacing="0" cellpadding="0" class="centered"&gt;
	&lt;tr&gt;
		&lt;td style="width:18px; height:111px; background-color:#FFFFFF" valign="top"&gt;&lt;img src="resources/top_left.png" width="18" height="111" alt="" class="layout"&gt;&lt;/td&gt;
		&lt;td style="width:720px; background:url('resources/top_bg.png') #FFFFFF repeat-x; text-align:center"&gt;
		&lt;span class="albumTitle"&gt;&lt;a href="index.html" style="color:#FFFFFF"&gt;<xsl:value-of select="$albumName"/>&lt;/a&gt;&lt;/span&gt;&lt;br&gt;
		&lt;span class="albumDescription"&gt;<xsl:value-of select="description"/>&lt;/span&gt;
		&lt;/td&gt;
		&lt;td style="width:18px; height:111px; background-color:#FFFFFF" valign="top"&gt;&lt;img src="resources/top_right.png" width="18" height="111" alt="" class="layout"&gt;&lt;/td&gt;
	&lt;/tr&gt;
	&lt;tr&gt;
		&lt;td style="width:18px; background:url('resources/side_left.png') #FFFFFF repeat-y"&gt;&lt;img src="resources/spacer.gif" width="18" height="1" alt="" class="layout"&gt;&lt;/td&gt;
		&lt;td style="width:720px; background-color:#FFFFFF; padding-top:12px"&gt;

</xsl:variable>



<!-- ####################### THIS IS THE FOOTER IN ESCAPED FORMAT ################## -->
<xsl:variable name="footer">
		&lt;/td&gt;
		&lt;td style="width:18px; background:url('resources/side_right.png') #FFFFFF repeat-y"&gt;&lt;img src="resources/spacer.gif" width="18" height="1" alt="" class="layout"&gt;&lt;/td&gt;
	&lt;/tr&gt;
	&lt;tr&gt;
		&lt;td style="width:18px; height:45px"&gt;&lt;img src="resources/bottom_left.png" width="18" height="45" alt="" class="layout"&gt;&lt;/td&gt;
		&lt;td style="width:720px; height:45px; background:url('resources/bottom_bg.png') #FFFFFF repeat-x" class="footer"&gt;

		Author: <xsl:value-of select="$albumAuthor"/> | Last modified: <xsl:value-of select="$Myear" />-<xsl:if test="$Mmonth &lt; 10">0</xsl:if><xsl:value-of select="$Mmonth"/>-<xsl:if test="$Mday &lt; 10">0</xsl:if><xsl:value-of select="$Mday"/>&lt;br&gt;
		This album was created with &lt;a href="http://albumshaper.sourceforge.net"&gt;Album Shaper&lt;/a&gt;, Radiant theme
			
		&lt;/td&gt;
		&lt;td style="width:18px; height:45px"&gt;&lt;img src="resources/bottom_right.png" width="18" height="45" alt="" class="layout"&gt;&lt;/td&gt;
	&lt;/tr&gt;
&lt;/table&gt;
&lt;/div&gt;
</xsl:variable>






<!-- index.html -->

<xsl:document method="html" indent="yes" href="{concat($outputPath, '/index.html')}" doctype-public="-//W3C//DTD HTML 4.01//EN" doctype-system="http://www.w3.org/TR/html4/strict.dtd">

<xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
<xsl:value-of select="$pageHeader"/>
<xsl:text disable-output-escaping="yes">--&gt;
</xsl:text>

<html>
<head>
	<title><xsl:value-of select="$albumName"/></title>
	
	<meta name="generator" content="Album Shaper (c.) Will Stokes" />
	<meta name="theme" content="{$themeVersion}" />
	<meta name="author" content="{$albumAuthor}" />

	<link rel="stylesheet" href="resources/style.css" type="text/css" />
</head>

<body>

<xsl:value-of select="$header" disable-output-escaping="yes" />


<xsl:if test="thumb">
	<xsl:variable name="albumThumbnail" select="thumb/@path"/>

<table cellspacing="0" cellpadding="0" class="centered">
<tr><td style="width:9px; height:8px; background-color:#F0F0F0"><img src="resources/photo_top_left.png" width="9" height="8" alt="" class="layout" /></td><td style="height:8px; background:url('resources/photo_top.png') #F0F0F0 repeat-x"><img src="resources/spacer.gif" width="1" height="8" alt="" class="layout" /></td><td style="width:11px; height:8px; background-color:#F0F0F0"><img src="resources/photo_top_right.png" width="11" height="8" alt="" class="layout" /></td></tr>
<tr><td style="width:9px; background:url('resources/photo_left.png') #F0F0F0 repeat-y"><img src="resources/spacer.gif" width="9" height="1" alt="" class="layout" /></td><td style="width:560px; background-color:#F0F0F0; text-align:center"><img src="{$albumThumbnail}" alt="{$albumName}" /></td><td style="width:11px; background:url('resources/photo_right.png') #F0F0F0 repeat-y"><img src="resources/spacer.gif" width="11" height="1" alt="" class="layout" /></td></tr>
<tr><td style="width:9px; height:12px; background-color:#F0F0F0"><img src="resources/photo_bottom_left.png" width="9" height="12" alt="" class="layout" /></td><td style="height:12px; background:url('resources/photo_bottom.png') #F0F0F0 repeat-x"><img src="resources/spacer.gif" width="1" height="12" alt="" class="layout" /></td><td style="width:11px; height:12px; background-color:#F0F0F0"><img src="resources/photo_bottom_right.png" width="11" height="12" alt="" class="layout" /></td></tr>
</table>
<br /><br />
</xsl:if>


<table style="width:100%" cellspacing="0" cellpadding="0">

<xsl:for-each select="subalbum">
	<xsl:variable name="subalbumNumber" select="position()"/>
	<xsl:variable name="subalbumName" select="name"/>
	
	<xsl:variable name="numCols">
		<xsl:choose>
			<xsl:when test="($subalbumNumber mod 2) and position() = last()">2</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:if test="$subalbumNumber mod 2"><xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text></xsl:if>

<td style="text-align:center" colspan="{$numCols}" valign="bottom">

<table cellspacing="0" cellpadding="0" class="centered">
<tr><td style="width:9px; height:8px; background-color:#F0F0F0"><img src="resources/photo_top_left.png" width="9" height="8" alt="" class="layout" /></td><td style="width:200px; height:8px; background:url('resources/photo_top.png') #F0F0F0 repeat-x"><img src="resources/spacer.gif" width="1" height="8" alt="" class="layout" /></td><td style="width:11px; height:8px; background-color:#F0F0F0"><img src="resources/photo_top_right.png" width="11" height="8" alt="" class="layout" /></td></tr>
<tr><td style="width:9px; background:url('resources/photo_left.png') #F0F0F0 repeat-y"><img src="resources/spacer.gif" width="9" height="1" alt="" class="layout" /></td><td style="width:200px; background-color:#F0F0F0; text-align:center" class="photoDescription">
<span class="subalbumLink">
<a href="subalbum_{$subalbumNumber}.html">
<xsl:if test="thumb">
	<xsl:variable name="subalbumThumbnail" select="thumb/@path"/>
	<img src="{$subalbumThumbnail}" alt="{$subalbumName}" class="centered" /><br />
</xsl:if>
<xsl:value-of select="$subalbumName"/></a></span><br />
<xsl:value-of select="description"/>
</td><td style="width:11px; background:url('resources/photo_right.png') #F0F0F0 repeat-y"><img src="resources/spacer.gif" width="11" height="1" alt="" class="layout" /></td></tr>
<tr><td style="width:9px; height:12px; background-color:#F0F0F0"><img src="resources/photo_bottom_left.png" width="9" height="12" alt="" class="layout" /></td><td style="width:200px; height:12px; background:url('resources/photo_bottom.png') #F0F0F0 repeat-x"><img src="resources/spacer.gif" width="1" height="12" alt="" class="layout" /></td><td style="width:11px; height:12px; background-color:#F0F0F0"><img src="resources/photo_bottom_right.png" width="11" height="12" alt="" class="layout" /></td></tr>
</table>

</td>

	<xsl:if test="not($subalbumNumber mod 2) and not(position() = last())">
	<xsl:text disable-output-escaping="yes">&lt;/tr&gt;
	&lt;tr&gt;&lt;td style="height:20px" colspan="2"&gt;&lt;img src="resources/spacer.gif" width="1" height="20" alt="" class="layout"&gt;&lt;/td&gt;&lt;/tr&gt;
	</xsl:text>
	</xsl:if>

</xsl:for-each>

<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
</table>


<xsl:value-of select="$footer" disable-output-escaping="yes" />


</body>
</html>
</xsl:document>






<xsl:for-each select="subalbum">
<xsl:variable name="subalbumNumber" select="position()"/>
<xsl:variable name="numPhotos" select="count(photo)"/>
<xsl:variable name="subalbumName" select="name"/>

<!-- subalbum_x.html -->
<xsl:document method="html" indent="yes" href="{concat($outputPath, '/subalbum_', $subalbumNumber, '.html')}" doctype-public="-//W3C//DTD HTML 4.01//EN" doctype-system="http://www.w3.org/TR/html4/strict.dtd">

<xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
<xsl:value-of select="$pageHeader"/>
<xsl:text disable-output-escaping="yes">--&gt;
</xsl:text>

<html>
<head>
	<meta name="generator" content="Album Shaper (c.) Will Stokes"/>
	<meta name="theme" content="{$themeVersion}" />
	<meta name="author" content="{$albumAuthor}" />

	<link rel="stylesheet" href="resources/style.css" type="text/css"/>
	
	<title><xsl:value-of select="$albumName"/> &#187; <xsl:value-of select="$subalbumName"/></title>
	
	<script type="text/javascript" src="resources/subalbum.js"></script>
</head>

<body>


<xsl:value-of select="$header" disable-output-escaping="yes" />

<div class="subalbumTitle"><xsl:value-of select="$subalbumName"/></div>
<div class="subalbumDescription"><xsl:value-of select="description"/></div>
<br />

<table cellspacing="0" cellpadding="0" class="centered">
	<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
<xsl:if test="not(count(photo))">
	<td class="slideshowDescription" style="text-align:center">
		This collection doesn't contain any images.
	</td>
</xsl:if>

<xsl:for-each select="photo">
	<xsl:variable name="photoDescription">	
	<xsl:call-template name="JavaScriptString"><xsl:with-param name="string" select="description"/></xsl:call-template>
	</xsl:variable>
	
	<td style="text-align:center; width:240px" valign="top">
	
<script type="text/javascript">box_start();</script>

<a href="slideshow_{$subalbumNumber}.html?{position()}" name="img{position()}"><img src="img/{$subalbumNumber}/{position()}_thumb.jpg" alt="" class="centered" /></a><br />
<xsl:if test="not($photoDescription = '')">
<xsl:value-of select="$photoDescription" disable-output-escaping="yes" />
</xsl:if>

<script type="text/javascript">box_end();</script>
	
	</td>
	<xsl:if test="not(position() mod 3)">
		<xsl:text disable-output-escaping="yes">&lt;/tr&gt;
</xsl:text>

		<xsl:if test="not(position() = $numPhotos)">
			<xsl:text disable-output-escaping="yes">&lt;tr&gt;&lt;td style="height:15px" colspan="3"&gt;&lt;img src="resources/spacer.gif" width="1" height="15" alt="" class="layout"&gt;&lt;/td&gt;&lt;/tr&gt;&lt;tr&gt;</xsl:text>
		</xsl:if>
	</xsl:if>
</xsl:for-each>

<xsl:if test="$numPhotos mod 3">
	<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
</xsl:if>

</table>


<xsl:value-of select="$footer" disable-output-escaping="yes" />


</body>
</html>
</xsl:document>



<!-- slideshow_x.html -->

<xsl:document method="html" indent="yes" href="{concat($outputPath, '/slideshow_', $subalbumNumber, '.html')}" doctype-public="-//W3C//DTD HTML 4.01//EN" doctype-system="http://www.w3.org/TR/html4/strict.dtd">

<xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
<xsl:value-of select="$pageHeader"/>
<xsl:text disable-output-escaping="yes">--&gt;
</xsl:text>

<html>
<head>
	<meta name="generator" content="Album Shaper (c.) Will Stokes"/>
	<meta name="theme" content="{$themeVersion}" />
	<meta name="author" content="{$albumAuthor}" />

	<link rel="stylesheet" href="resources/style.css" type="text/css" />
	
	<title><xsl:value-of select="$albumName"/> &#187; <xsl:value-of select="$subalbumName"/></title>
	
	<script type="text/javascript">
	
	function viewImage(img) {
		self.location.href = 'slideshow_<xsl:value-of select="$subalbumNumber"/>.html?' + img;
	}
	
	function nextImage() {if (image <![CDATA[<]]> <xsl:value-of select="$numPhotos"/>) viewImage(image + 1);}
	function previousImage() {if (image > 1) viewImage(image - 1);}
	function firstImage() {viewImage(1);}
	function lastImage() {viewImage(<xsl:value-of select="$numPhotos"/>);}
	
	var url = self.location.href.split('?');
	var image = url[1] ? parseInt(url[1]) : 1;
	if (image <![CDATA[<]]> 1 || image <![CDATA[>]]> <xsl:value-of select="$numPhotos"/>) image = 1;
	
	var imageDescription = new Array(<xsl:value-of select="$numPhotos"/>);
	<xsl:for-each select="photo">
	<xsl:variable name="photoDescription" select="description"/>
	imageDescription[<xsl:value-of select="position() - 1"/>] = <![CDATA["]]><xsl:call-template name="JavaScriptString"><xsl:with-param name="string" select="$photoDescription"/></xsl:call-template><![CDATA["]]>;</xsl:for-each>
	
	</script>
	<script type="text/javascript" src="resources/slideshow.js"></script>
</head>

<body>


<xsl:value-of select="$header" disable-output-escaping="yes" />


<table cellspacing="0" cellpadding="0" class="centered">
	<tr>
		<td colspan="5" style="text-align:center" class="subalbumTitle">
		<script type="text/javascript">
		<![CDATA[
		document.write('<'+'a href="subalbum_]]><xsl:value-of select="$subalbumNumber"/><![CDATA[.html#img' + image + '">]]><xsl:value-of select="$subalbumName"/><![CDATA[<'+'/a>');
		]]>
		</script>
		</td>
	</tr>
	<tr>
		<td style="width:225px; height:15px"><img src="resources/spacer.gif" width="225" height="1" alt="" /></td>
		<td style="width:25px; height:15px">
		<script type="text/javascript">
		<![CDATA[
		if (image > 1) document.write('<'+'a href="slideshow_]]><xsl:value-of select="$subalbumNumber"/><![CDATA[.html?' + (image - 1) + '" title="Previous Image (Left Key)"><img src="resources/arrow_left.png" alt="Previous Image" width="5" height="11"><img src="resources/spacer.gif" width="5" height="11" alt=""><img src="resources/image.png" width="15" height="11" alt=""><'+'/a>');
		]]>
		</script>
		</td>
		<td style="width:100px; height:15px; text-align:center" class="photoDescription">
		<script type="text/javascript">
		document.write(image + '(<xsl:value-of select="$numPhotos"/>)');
		</script>
		</td>
		<td style="width:25px; height:15px">
		<script type="text/javascript">
		<![CDATA[
		if (image < ]]><xsl:value-of select="$numPhotos"/><![CDATA[) document.write('<'+'a href="slideshow_]]><xsl:value-of select="$subalbumNumber"/><![CDATA[.html?' + (image + 1) + '" title="Next Image (Right Key)"><img src="resources/image.png" width="15" height="11" alt=""><img src="resources/spacer.gif" width="5" height="11" alt=""><img src="resources/arrow_right.png" alt="Next Image" width="5" height="11"><'+'/a>');
		]]>
		</script>
		</td>
		<td style="width:225px; height:15px"><img src="resources/spacer.gif" width="225" height="1" alt="" /></td>
	</tr>
	<tr>
		<td colspan="5">
		
<script type="text/javascript">

<xsl:if test="$smallWebExport = 0">
document.write('<![CDATA[<]]>a href="img/<xsl:value-of select="$subalbumNumber"/>/' + image + '.jpg" target="_blank"<![CDATA[>]]>');
</xsl:if>
document.write('<![CDATA[<]]>img src="img/<xsl:value-of select="$subalbumNumber"/>/' + image + '_slideshow.jpg" width="600" height="400" alt=""<![CDATA[>]]>');
<xsl:if test="$smallWebExport = 0">
<![CDATA[
document.write('<'+'/a>');
]]>
</xsl:if>
</script>
		
		</td>
	</tr>
	<tr>
		<td colspan="5" class="slideshowDescription">
			<script type="text/javascript">
			if (imageDescription[image - 1] != '') document.write(imageDescription[image - 1]);
			</script>
		</td>
	</tr>
</table>


<xsl:value-of select="$footer" disable-output-escaping="yes" />

</body>
</html>
</xsl:document>



</xsl:for-each>





</xsl:template>

</xsl:stylesheet>