/*
 This collection of routines is innteded to provide the tools
 by which one can create and add plots to a container in a
 programmatic fashion. This is to be contrasted with the GUI 
 tools that construct a collection of plots in a pre-defined
 manner specified by the menu or button action and that, by the
 interface, cannot allow parameterization of the creation.

 
 It is important to be able to add individual plots to an existing
 container.
 */

#include "RSGGobi.h"
#include "RUtils.h"

#include <gtk/gtk.h>

#include "vars.h"

#include "R.h"
#include "Rinternals.h"

#if 0

splotd *RS_GGOBI(createSPlot)(displayd *display, datad *data, SEXP desc, gint *dims, ggobid *gg, displayd** embedded);

displayd *RS_GGOBI(createEmbeddedPlot)(gint numRows, gint numCols, datad *d, displayd *, ggobid *gg);
/*
  Lays out the plots given in the list `plotDescList' 
  in a grid/table format of dimension
 */
SEXP
RS_GGOBI(createPlots)(SEXP plotDescList, SEXP dims, SEXP cells, SEXP gobiId, SEXP rdisplay, SEXP dataset)
{
  SEXP ans;
  int n = GET_LENGTH(plotDescList), i;
  int numRows, numCols;
  splotd *sp;
  displayd *display, *embeddedDisplay;
  GtkWidget *cell;
  datad *d = NULL;
  ggobid *gg = NULL;
  gint *plotDims;
  gint left, top, bottom, right, ctr;
 
  d = resolveDatad(dataset, gobiId, &gg);
  if(!d)
    return(NULL_USER_OBJECT);

  display = GetDisplay(rdisplay, gobiId, NULL);

  numRows = INTEGER_DATA(dims)[0];
  numCols = INTEGER_DATA(dims)[1];

  if(!display) {
    display = display_alloc_init (scatmat, false, d, gg);
    plotDims = createScatmatWindow(numRows, numCols, display, gg, true);
    display->splots = NULL;
  } else {
    plotDims = (gint *)g_malloc(2 * sizeof(int));
    if(display->splots  && display->splots->data) {
      splotd *tmpSP = (splotd *)display->splots->data;
      plotDims[0] = tmpSP->max.x;
      plotDims[1] = tmpSP->max.y;
    } else {
      plotDims[0] = plotDims[1] = 200;
    }
    d = display->d;
  }


  ctr = 0;
  for(i = 0; i < n ; i++, ctr+=4) {
    embeddedDisplay = (displayd *)NULL;
    sp = RS_GGOBI(createSPlot)(display, d, VECTOR_ELT(plotDescList, i), plotDims, gg, &embeddedDisplay);

    if(sp == (splotd *) NULL && embeddedDisplay == (displayd*) NULL)
      continue;
    if(sp != NULL) {
      display->splots = g_list_append(display->splots, (gpointer) sp);      
      cell = sp->da;
    } else {
        /* Register the embedded display with the ggobi. */
      GList *tmp = embeddedDisplay->splots;
      display_add(embeddedDisplay, gg);
      cell = embeddedDisplay->table;
        /* Add each of the splots to their outer parent. */
      while(tmp != (GList*) NULL) {
        display->splots = g_list_append(display->splots, (gpointer) tmp->data);      
        tmp = tmp->next;
      }
    }

    left = INTEGER_DATA(cells)[ctr];
    right = INTEGER_DATA(cells)[ctr+1];
    top = INTEGER_DATA(cells)[ctr+2];
    bottom = INTEGER_DATA(cells)[ctr+3];

    gtk_table_attach(GTK_TABLE (display->table), 
        cell, 
        left, right, top, bottom,
        (GtkAttachOptions) (GTK_SHRINK|GTK_FILL|GTK_EXPAND), 
        (GtkAttachOptions) (GTK_SHRINK|GTK_FILL|GTK_EXPAND),
        1, 1);
    gtk_widget_show (cell);
  }

/*
  display->scatmat_cols = NULL;
  for (j=0; j<scatmat_ncols; j++)
    display->scatmat_cols = g_list_append (display->scatmat_cols,
                                           GINT_TO_POINTER (j));
  display->scatmat_rows = NULL;
  for (i=0; i<scatmat_nrows; i++)
    display->scatmat_rows = g_list_append (display->scatmat_rows,
                                           GINT_TO_POINTER (i));
*/
  if(n > 0) {
      gtk_widget_show(display->table);
      if(GTK_IS_GGOBI_WINDOW_DISPLAY(display))
	  gtk_widget_show_all (GTK_GGOBI_WINDOW_DISPLAY(display)->window);
  } else
      display->scatmat_cols = NULL;

  g_free(plotDims);

  if(INTEGER_DATA(rdisplay)[0] < 0) {
    PROTECT(ans = NEW_INTEGER(1));
    INTEGER_DATA(ans)[0] = display_add(display, gg);
    UNPROTECT(1);
  } else {
    ans = rdisplay;
    INTEGER_DATA(ans)[0]++;
  }

  gdk_flush();

 return(ans);
}


splotd *
RS_GGOBI(createSPlot)(displayd *display, datad *data, SEXP desc, gint *dims, ggobid *gg, displayd** embeddedDisplay)
{
 splotd *sp = (splotd*) NULL;

 if(GET_LENGTH(desc) == 0)
   return((splotd*)NULL);

 if(R_IS(desc, "ScatmatrixPlot")) {
    gint r,c;
    int i,j;
    gint width, height;
    r = c = GET_LENGTH(VECTOR_ELT(desc, 0));
    width = dims[0]/c;
    height = dims[1]/r;
    *embeddedDisplay = RS_GGOBI(createEmbeddedPlot)(r, c, data, display, gg);
    for(i = 0; i < r ;  i++) {
       for(j = 0; j < c ;  j++) {
       sp = splot_new (*embeddedDisplay, width, height, gg);
       sp->xyvars.x = INTEGER_DATA(VECTOR_ELT(desc,0))[i] - 1; 
       sp->xyvars.y = INTEGER_DATA(VECTOR_ELT(desc, 0))[j] - 1; 
       sp->p1dvar = (sp->xyvars.x == sp->xyvars.y) ? sp->xyvars.x : -1;
  
       (*embeddedDisplay)->splots = g_list_append ((*embeddedDisplay)->splots, (gpointer) sp);
  
       gtk_table_attach (GTK_TABLE ((*embeddedDisplay)->table), sp->da, i, i+1, j, j+1,
  	 (GtkAttachOptions) (GTK_SHRINK|GTK_FILL|GTK_EXPAND), 
  	 (GtkAttachOptions) (GTK_SHRINK|GTK_FILL|GTK_EXPAND),
  	 1, 1);
       gtk_widget_show (sp->da);          
      }
    }
    return( (splotd *) NULL);
 } else if(R_IS(desc, "MultipleParallelCoordinates")) {
    gint r,c;
    int j;
    gint width, height;
    c = GET_LENGTH(VECTOR_ELT(desc, 0));
    r = 1;
    width = dims[0]/c;
    height = dims[1]/r;
    *embeddedDisplay = RS_GGOBI(createEmbeddedPlot)(r, c, data, display, gg);
    (*embeddedDisplay)->displaytype = parcoords;
    (*embeddedDisplay)->p1d_orientation = VERTICAL;
    (*embeddedDisplay)->cpanel.p1d.type = DOTPLOT;
     for(j = 0; j < c ;  j++) {
       sp = splot_new (*embeddedDisplay, width, height, gg);
       sp->xyvars.x = INTEGER_DATA(VECTOR_ELT(desc, 0))[j] - 1;
       sp->p1dvar = sp->xyvars.x;

       (*embeddedDisplay)->splots = g_list_append ((*embeddedDisplay)->splots, (gpointer) sp);
  
       gtk_table_attach (GTK_TABLE ((*embeddedDisplay)->table), sp->da, j, j+1, 0, 1,
  	 (GtkAttachOptions) (GTK_SHRINK|GTK_FILL|GTK_EXPAND), 
  	 (GtkAttachOptions) (GTK_SHRINK|GTK_FILL|GTK_EXPAND),
  	 1, 1);
       gtk_widget_show (sp->da);          
    }
    return( (splotd *) NULL);

 } else if(R_IS(desc, "TimeSeriesPlot")) {
   PROBLEM "Creating TimeSeriesPlot not handled yet!"
     WARN;
   return(NULL);
 } 


  sp = splot_new (display, dims[0], dims[1], gg);
  if(R_IS(desc, "ScatterPlot")) {
    USER_OBJECT_ varIds =  VECTOR_ELT(desc, 0);
     sp->xyvars.x = INTEGER_DATA(varIds)[0] - 1;
     sp->xyvars.y = INTEGER_DATA(varIds)[1] - 1;
     sp->p1dvar = -1;
  } else if(R_IS(desc, "ParallelCoordinates")) {
    USER_OBJECT_ varIds =  VECTOR_ELT(desc, 0);
     sp->p1dvar = INTEGER_DATA(varIds)[0];
  } else if(R_IS(desc, "GGobiAsh")) {
    USER_OBJECT_ varIds =  VECTOR_ELT(desc, 0);
     sp->p1dvar = INTEGER_DATA(varIds)[0];
  } 

 return(sp);
}


displayd *
RS_GGOBI(createEmbeddedPlot)(gint numRows, gint numCols, datad *d, displayd *owner, ggobid *gg)
{
  gint *plotDims;
  displayd *display;
    display = display_alloc_init(scatmat, false, d, gg);
    display->d = d;
/*XXX Handle the creation of a GtkGGobiDisplay, not a GtkGGobiWindowDisplay. */
    plotDims = createScatmatWindow(numRows, numCols, display, gg, false);
    display->splots = NULL;
    display->displaytype = scatmat;
 return(display);
}



/*
  Allows the R user to set the variables within a given plot.
  Returns the previous settings in place of those that were
  given by the user. This allows the values to be restored
  easily at a later time.
 */
USER_OBJECT_
RS_GGOBI(setPlotVariables)(USER_OBJECT_ varIds, USER_OBJECT_ dpy,
 			    USER_OBJECT_ plotId, USER_OBJECT_ ggobiId)
{
  displayd *display;
  splotd *sp;
  long oldx, oldy;
  USER_OBJECT_ ans;
  int n;

  display = GetDisplay(dpy, ggobiId, NULL);
  if(display == NULL)
    return(NULL_USER_OBJECT);
  
  sp = (splotd*)g_list_nth_data(display->splots, INTEGER_DATA(plotId)[0]);
  if(sp == NULL) {
    PROBLEM "No such plot %d within this ggobi display" ,
                   (int) INTEGER_DATA(plotId)[0]
    ERROR;
  }

  switch(display->displaytype) {
   case scatterplot:
   case scatmat:
     oldx = sp->xyvars.x + 1;
     oldy = sp->xyvars.y + 1;
     sp->xyvars.x = INTEGER_DATA(varIds)[0];
     sp->xyvars.y = INTEGER_DATA(varIds)[1];
     n = 2;
     break;
   case parcoords:
     oldx = sp->p1dvar +1;
     sp->p1dvar = INTEGER_DATA(varIds)[0];
     n = 1;
     break;
    default:
  }

  ans = NEW_INTEGER(n);
  INTEGER_DATA(ans)[0] = oldx;
   
  if(n > 1) {
    INTEGER_DATA(ans)[1] = oldy;
  }

 return(ans);
}


/**
 This is called when we have reset all the variables in the different
 splots within a display.
 The intent is that this will recompute everything, including the 
 positions of the points/glyphs. Currently this is not doing that.
 Need to call some other method.
 */
USER_OBJECT_
RS_GGOBI(updateDisplay)(USER_OBJECT_ dpy, USER_OBJECT_ ggobiId)
{
 USER_OBJECT_  ans = NEW_LOGICAL(1);
  ggobid *gg;
  displayd *display;  

  if((display = GetDisplay(dpy, ggobiId, &gg))) {
      /*    ruler_ranges_set(display, sp, gg); */
    display_tailpipe(display, FULL,  gg);
    /*    displays_plot(NULL, FULL,  gg); */

    /*
      varpanel_refresh (display, gg);
    */

    gdk_flush();
    LOGICAL_DATA(ans)[0] = TRUE;
  }
  return(ans);
}


/*
  Returns a string identifying the 
  type of plots contained within a particular displayd
  object.
  (Note that this is not useful for programmatically created
   plots with non-homegeneous types.)
 */
SEXP
RS_GGOBI(getDisplayType)(SEXP dpy, SEXP ggobiId)
{
  displayd *display;
  char *tmp = NULL;
  SEXP ans, names;

  display = GetDisplay(dpy, ggobiId, NULL);
   
  if(display) {
     tmp = gtk_display_title_label(display);
     PROTECT(ans = NEW_CHARACTER(1));
     PROTECT(names = NEW_CHARACTER(1));
     SET_STRING_ELT(ans, 0, COPY_TO_USER_STRING(tmp));
     SET_STRING_ELT(names, 0, COPY_TO_USER_STRING(getDisplayTypeName(display)));
     UNPROTECT(1);
  } else 
    ans = NULL_USER_OBJECT;

 return(ans);
}

#endif

/*
 Returns the number of splotd objects contained within a
 a given displayd object.
 */

USER_OBJECT_
RS_GGOBI(getNumPlotsInDisplay)(USER_OBJECT_ dpy, USER_OBJECT_ ggobiId)
{
  displayd *display;

  USER_OBJECT_ ans = NEW_INTEGER(1);
  display = GetDisplay(dpy, ggobiId, NULL);
  if(display) {
   int len;
      len = g_list_length(display->splots);
      INTEGER_DATA(ans)[0] = len;
  }

 return(ans);
}

USER_OBJECT_
RS_GGOBI(getNumDisplays)(USER_OBJECT_ ggobiId)
{
  ggobid *gg = GetGGobi(ggobiId);
  int len;
  USER_OBJECT_ ans = NEW_INTEGER(1);
  if(gg) {
   len = g_list_length(gg->displays);
   INTEGER_DATA(ans)[0] = len;
  }

 return(ans);
}

