\name{variableInfo}
\alias{variableInfo}
\alias{categoricalVariableInfo}
\alias{realVariableInfo}
\alias{realVariableInfo.XMLNode}
\alias{categoricalVariableInfo.XMLNode}
\alias{variableInfo.XMLNode}
\title{GGobi XML Data Description}
\description{
  Each of these methods create  a description
  of a variable within a GGobi dataset,
  providing its name, help string, description, any levels for
  categorical variables, ranges for real variables, etc.
  In general, these are not called directly at present.
  Instead, they are used when processing an XML file describing
  a dataset.
}
\usage{
variableInfo(x, ...)
categoricalVariableInfo(x, ...)
realVariableInfo(x, ...)
realVariableInfo.XMLNode(x, ..., numericFields = c("min", "max"))
categoricalVariableInfo.XMLNode(x, ..., numericFields = c("min", "max"))
variableInfo.XMLNode(x, ..., className = NULL)
}
\arguments{
  \item{x}{}
  \item{\dots}{}
  \item{numericFields}{}
  \item{className}{}  
}
\details{

}
\value{
  An object of
  class \code{CategoricalVariableInfo}
  or \code{RealVariableInfo}
  which extend \code{VariableInfo}.
  The \code{VariableInfo} class
  has basic slots
  \item{name}{}
  \item{nickname}{}
  \item{description}{}
  \item{quickHelp}{}
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
  \code{\link{xmlDataViewer}}
  \code{\link{dataDescriptionHandlers}}
}

\examples{

}
\keyword{IO}

