\name{setDataFile.ggobi}
\alias{setDataFile.ggobi}
\title{Load data from a file into a ggobi instance}
\description{
 This replaces the existing data in the specified ggobi instance
with the dataset(s) in the file given by name.
}
\usage{
setDataFile.ggobi(file, mode="unknown", add = TRUE, .gobi=getDefaultGGobi())
}
\arguments{
  \item{file}{the name of the file from which to read the data.
   Note that if XML support has been compiled for ggobi, this can be a
   compressed file or even a URL.}
  \item{mode}{this indicates which format to expect the data to be in. This is
 optional and if not supplied, the ggobi system attempts to find the file 
 by looking through different extensions and checking the contents for a valid data stream.
 This helps to avoid loading data unitentionally due to name conflicts.
 }
  \item{add}{a logical value indicating whether to add the newly loaded dataset
  to the existing collection of data sets, or simply to replace them.}
  \item{.gobi}{the ggobi instance into which the new data should be loaded.
  This is needed only if there are multiple ggobi instances and the
  target is not the currently active/default instance.}
}
\details{
 This re-initializes the ggobi instance, discarding the existing
data and plots, and creating the default starting view.
}
\value{
 a logical value indicating whether the load was successful. \\
 In the future, this might be a dataset description.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{ggobi}}
\code{\link{setDataFrame.ggobi}}
\code{\link{getFileNames.ggobi}}
}

\examples{
\dontrun{
#XXX
 setDataFile.ggobi(system.file("datasets", "flea.xml", package="RSggobi"))
 setData.ggobi(system.file("datasets", "flea.xml", package="RSggobi"))
}

\dontrun{
 setData.ggobi("http://www.ggobi.org/data/flea.xml")
}
}
\keyword{iplot}
