\name{resolveColors.ggobi}
\alias{resolveColors.ggobi}
\title{Map names to color values in a ggobi instance.}
\description{
  This currently does not work but will when color schemes
  are enabled in GGobi.

  Colors in ggobi are represented by entries in a color
  table or matrix as Red, Green and Blue values.
  To set a color, one can identify the entry in that table 
  either by number/index or by name.
  This function maps color names to the corresponding
  index so that these values can be passed to the low-leve
  C routines.  This function is typically called internally.
}
\usage{
resolveColors.ggobi(colNames, scheme = NULL, .gobi=getDefaultGGobi())
}
\arguments{
  \item{colNames}{names of colors to be resolved in the specified
    color scheme of the ggobi instance.}
  \item{scheme}{the name of the particular color scheme of interest in
    which to resolve the color names. This name is used to lookup the
    color scheme in the list of color schemes associated with the GGobi
    instance or session options.}
 \item{.gobi}{the ggobi instance whose color schemes are to be used
   to resolve the \code{scheme}. If this is \code{NULL},
    the color schemes from the GGobi session options are used.
  }
}
\value{
 An integer vector specifying the indices of the 
 entries in the color scheme corresponding to the specified
 names.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{ 
 \code{\link{getColors.ggobi}}
 \code{\link{setColors.ggobi}}
 \code{\link{getColorSchemes}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"))
\dontrun{
  g$resolveColors("red", "green")
}
}
\keyword{iplot}
\keyword{dynamic}
