\name{createEdgeDataset.ggobi}
\alias{createEdgeDataset.ggobi}
\title{Create a GGobi dataset for representing edges}
\description{
  This allows us to create an empty  GGobi dataset that we can also use
  to represent edges between nodes in another dataset.
  After creating the dataset, we can add variables as we desire.
  The variables in this dataset are associated with the edges
  and we can brush and identify edges and highlight
  records in the displays for this dataset.
}
\usage{
createEdgeDataset.ggobi(n, name = "<empty>", description = "Empty dataset!", add = TRUE, ids = as.character(seq(1, n)), .gobi = getDefaultGGobi())
}
\arguments{
  \item{n}{the number of records that will be in this dataset}
  \item{name}{the name to use for the dataset}
  \item{description}{a human readable description of the dataset that
    can be displayed to inform the user of its origin and purpose.}
  \item{add}{currently ignored.}
  \item{ids}{names for the records in the dataset.}
  \item{.gobi}{the GGobi instance in which to create the new dataset.}
}
\details{

}
\value{
  An object of class \code{ggobiDataset} that identifies
  the particular dataset.
}

\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
  \code{\link{getDatasetReference}}
  \code{\link{ggobi}}
  \code{\link{setData.ggobi}}
}
\examples{

}
\keyword{IO}

