\name{checkStructs.ggobi}
\alias{checkStructs.ggobi}
\title{Validates GGobi and Rggobi views of internal data structures}
\description{
  This function is called when the Rggobi library is loaded
  and it verifies that the sizes of the different internal
  data structures for GGobi are the same for both the GGobi shared
  library/DLL and the Rggobi package.  This is important as the
  two shared libraries are compiled separately and may have different
  compilation flags, etc. that make them incompatible.
  This function simply compares the sizes of the two views of the
  structures and raises a warning if they do not agree.
}
\usage{
checkStructs.ggobi()
}

\value{
  If the sizes in the two libraries are the same, this returns
  \code{TRUE}.
  Otherwise, it returns a named logical vector indicating which
  structures do not have the same sizes in the two libraries.

  Essentially, you should never notice this function.
  A warning implies that you need to re-install Rggobi against
  the version of GGobi you are using.
}

\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\examples{

}
\keyword{programming}

