\name{addXMLDataset}
\alias{addXMLDataset}
\title{Serialize dataset to GGobi's XML format.}
\description{
  This writes a dataset in the XML format
  used by GGobi
}
\usage{
addXMLDataset(data, name, dom, description = NULL, asElements = TRUE)
}
\arguments{
  \item{data}{the dataset to be serialized.}
  \item{name}{the name to use for the \code{name} attribute for the dataset}
  \item{dom}{the output object to which to write the XML. This is
    usually an object of class \code{XMLOutputStream}.}
  \item{description}{an optional string or XML node giving a
    human-readable description of the dataset.}
  \item{asElements}{a logical value indicating whether the individual
    values should be output within <el> </el> nodes or, if \code{FALSE},
    simply as space-separated numbers/values.}
}
\details{
  See \code{\link{writeDataXML}}. 
}
\value{

}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
 \code{\link{writeDataXML}}
}

\examples{
if(require(XML)) {
 data(mtcars)
 dd <- xmlOutputBuffer()
 dd$addTag("ggobidata", close = FALSE)
 addXMLDataset(mtcars, "mtcars", dd, "The mtcars data taken from R")
 dd$closeTag()
 cat(dd$value())
}
}
\keyword{iplot}
\keyword{dynamic}
